/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.model.library.CatalogEntryManager;
import org.protege.editor.owl.ui.library.NewEntryPanel;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.Entry;

public class AddEntryDialog
extends JDialog {
    private static final long serialVersionUID = 8162358678767968590L;
    private List<CatalogEntryManager> entryManagers;
    private XMLCatalog catalog;
    private JTabbedPane tabs;
    private JButton ok;
    private boolean cancelled = false;

    public static Entry askUserForRepository(JComponent parent, XMLCatalog catalog, List<CatalogEntryManager> entryManagers) {
        AddEntryDialog dialog = new AddEntryDialog((JDialog)SwingUtilities.getAncestorOfClass(JDialog.class, parent), entryManagers, catalog);
        dialog.setVisible(true);
        Entry e = dialog.getEntry();
        if (e != null) {
            catalog.addEntry(0, e);
            for (CatalogEntryManager entryManager : entryManagers) {
                if (!entryManager.isSuitable(e)) continue;
                try {
                    entryManager.update(e);
                }
                catch (IOException ioe) {
                    ProtegeApplication.getErrorLog().logError((Throwable)ioe);
                }
            }
        }
        return e;
    }

    public AddEntryDialog(JDialog parent, List<CatalogEntryManager> entryManagers, XMLCatalog catalog) {
        super((Dialog)parent, true);
        this.entryManagers = entryManagers;
        this.catalog = catalog;
        this.setLayout(new BorderLayout());
        this.add((Component)this.createTabbedPane(), "Center");
        this.add((Component)this.createButtons(), "South");
        this.pack();
        this.repaint();
    }

    private JTabbedPane createTabbedPane() {
        this.tabs = new JTabbedPane();
        for (CatalogEntryManager entryManager : this.entryManagers) {
            NewEntryPanel panel = entryManager.newEntryPanel(this.catalog);
            panel.setAlignmentY(0.5f);
            this.tabs.addTab(entryManager.getDescription(), panel);
            panel.addListener(new Runnable(){

                @Override
                public void run() {
                    AddEntryDialog.this.updateOkButtonState();
                }
            });
        }
        this.tabs.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AddEntryDialog.this.updateOkButtonState();
            }
        });
        return this.tabs;
    }

    private JComponent createButtons() {
        JPanel bottom = new JPanel();
        this.ok = new JButton("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddEntryDialog.this.setVisible(false);
            }
        });
        this.ok.setAlignmentX(0.5f);
        this.updateOkButtonState();
        bottom.add(this.ok);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AddEntryDialog.this.setVisible(false);
                AddEntryDialog.this.cancelled = true;
            }
        });
        cancel.setAlignmentX(0.5f);
        bottom.add(cancel);
        return bottom;
    }

    public Entry getEntry() {
        NewEntryPanel panel = (NewEntryPanel)this.tabs.getSelectedComponent();
        return !this.cancelled ? panel.getEntry() : null;
    }

    private void updateOkButtonState() {
        NewEntryPanel panel = (NewEntryPanel)this.tabs.getSelectedComponent();
        this.ok.setEnabled(panel.getEntry() != null);
    }
}

