/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.framelist;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.util.ClosureAxiomFactory;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.framelist.OWLFrameListPopupMenuAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class CreateClosureAxiomAction
extends OWLFrameListPopupMenuAction<OWLClass> {
    @Override
    protected String getName() {
        return "Create closure axiom";
    }

    @Override
    protected void initialise() throws Exception {
    }

    @Override
    protected void dispose() throws Exception {
    }

    private Set<OWLObjectProperty> getPropertiesFromSelection() {
        ClosureSourceIdentifier closureSourceIdentifier = new ClosureSourceIdentifier();
        for (Object selVal : this.getFrameList().getSelectedValues()) {
            if (!(selVal instanceof OWLFrameSectionRow)) continue;
            Object ax = ((OWLFrameSectionRow)selVal).getAxiom();
            ax.accept((OWLObjectVisitor)closureSourceIdentifier);
        }
        return closureSourceIdentifier.getPropertiesToClose();
    }

    @Override
    protected void updateState() {
        this.setEnabled(!this.getPropertiesFromSelection().isEmpty());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        OWLOntology activeOnt = this.getOWLModelManager().getActiveOntology();
        Set<OWLOntology> activeOnts = this.getOWLModelManager().getActiveOntologies();
        OWLDataFactory df = this.getOWLModelManager().getOWLDataFactory();
        OWLClass root = (OWLClass)this.getRootObject();
        for (OWLObjectProperty prop : this.getPropertiesFromSelection()) {
            OWLAxiom ax = ClosureAxiomFactory.getClosureAxiom(root, prop, df, activeOnts);
            if (ax == null || activeOnt.containsAxiom(ax)) continue;
            changes.add(new AddAxiom(activeOnt, ax));
        }
        if (!changes.isEmpty()) {
            this.getOWLModelManager().applyChanges(changes);
        }
    }

    class ClosureSourceIdentifier
    extends OWLObjectVisitorAdapter {
        private final Set<OWLObjectProperty> propertiesToClose = new HashSet<OWLObjectProperty>();
        private Set<OWLObject> visited = new HashSet<OWLObject>();

        ClosureSourceIdentifier() {
        }

        public Set<OWLObjectProperty> getPropertiesToClose() {
            return this.propertiesToClose;
        }

        public void visit(OWLSubClassOfAxiom owlSubClassAxiom) {
            if (!this.visited.contains(owlSubClassAxiom)) {
                this.visited.add((OWLObject)owlSubClassAxiom);
                owlSubClassAxiom.getSuperClass().accept((OWLObjectVisitor)this);
            }
        }

        public void visit(OWLEquivalentClassesAxiom owlEquivalentClassesAxiom) {
            if (!this.visited.contains(owlEquivalentClassesAxiom)) {
                this.visited.add((OWLObject)owlEquivalentClassesAxiom);
                for (OWLClassExpression op : owlEquivalentClassesAxiom.getClassExpressions()) {
                    op.accept((OWLObjectVisitor)this);
                }
            }
        }

        public void visit(OWLObjectIntersectionOf owlObjectIntersectionOf) {
            for (OWLClassExpression op : owlObjectIntersectionOf.getOperands()) {
                op.accept((OWLObjectVisitor)this);
            }
        }

        public void visit(OWLObjectSomeValuesFrom restr) {
            ((OWLObjectPropertyExpression)restr.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectMinCardinality restr) {
            ((OWLObjectPropertyExpression)restr.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectExactCardinality restr) {
            ((OWLObjectPropertyExpression)restr.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectHasValue restr) {
            ((OWLObjectPropertyExpression)restr.getProperty()).accept((OWLObjectVisitor)this);
        }

        public void visit(OWLObjectProperty owlObjectProperty) {
            this.propertiesToClose.add(owlObjectProperty);
        }
    }
}

