/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyIndividualPairEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLObjectPropertyIndividualPair;
import org.protege.editor.owl.ui.frame.individual.OWLObjectPropertyAssertionAxiomFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.reasoner.NodeSet;

public class OWLObjectPropertyAssertionAxiomFrameSection
extends AbstractOWLFrameSection<OWLIndividual, OWLObjectPropertyAssertionAxiom, OWLObjectPropertyIndividualPair> {
    public static final String LABEL = "Object property assertions";
    private Set<OWLObjectPropertyAssertionAxiom> added = new HashSet<OWLObjectPropertyAssertionAxiom>();

    public OWLObjectPropertyAssertionAxiomFrameSection(OWLEditorKit owlEditorKit, OWLFrame<? extends OWLIndividual> frame) {
        super(owlEditorKit, LABEL, "Object property assertion", frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        this.added.clear();
        for (OWLObjectPropertyAssertionAxiom ax : ontology.getObjectPropertyAssertionAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLObjectPropertyAssertionAxiomFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLIndividual)this.getRootObject(), ax));
            this.added.add(ax);
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_OBJECT_PROPERTY_ASSERTIONS, new Runnable(){

            @Override
            public void run() {
                if (!OWLObjectPropertyAssertionAxiomFrameSection.this.getOWLModelManager().getReasoner().isConsistent()) {
                    return;
                }
                OWLDataFactory factory = OWLObjectPropertyAssertionAxiomFrameSection.this.getOWLDataFactory();
                if (!((OWLIndividual)OWLObjectPropertyAssertionAxiomFrameSection.this.getRootObject()).isAnonymous()) {
                    for (OWLObjectProperty prop : OWLObjectPropertyAssertionAxiomFrameSection.this.getReasoner().getRootOntology().getObjectPropertiesInSignature(true)) {
                        if (prop.equals(factory.getOWLTopObjectProperty())) continue;
                        NodeSet values = OWLObjectPropertyAssertionAxiomFrameSection.this.getReasoner().getObjectPropertyValues(((OWLIndividual)OWLObjectPropertyAssertionAxiomFrameSection.this.getRootObject()).asOWLNamedIndividual(), (OWLObjectPropertyExpression)prop);
                        for (OWLNamedIndividual ind : values.getFlattened()) {
                            OWLObjectPropertyAssertionAxiom ax = OWLObjectPropertyAssertionAxiomFrameSection.this.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom((OWLObjectPropertyExpression)prop, (OWLIndividual)OWLObjectPropertyAssertionAxiomFrameSection.this.getRootObject(), (OWLIndividual)ind);
                            if (OWLObjectPropertyAssertionAxiomFrameSection.this.added.contains(ax)) continue;
                            OWLObjectPropertyAssertionAxiomFrameSection.this.addRow(new OWLObjectPropertyAssertionAxiomFrameSectionRow(OWLObjectPropertyAssertionAxiomFrameSection.this.getOWLEditorKit(), OWLObjectPropertyAssertionAxiomFrameSection.this, null, (OWLIndividual)OWLObjectPropertyAssertionAxiomFrameSection.this.getRootObject(), ax));
                        }
                    }
                }
            }
        });
    }

    @Override
    protected OWLObjectPropertyAssertionAxiom createAxiom(OWLObjectPropertyIndividualPair object) {
        return this.getOWLDataFactory().getOWLObjectPropertyAssertionAxiom(object.getProperty(), (OWLIndividual)this.getRootObject(), object.getIndividual());
    }

    @Override
    public OWLObjectEditor<OWLObjectPropertyIndividualPair> getObjectEditor() {
        return new OWLObjectPropertyIndividualPairEditor(this.getOWLEditorKit());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLIndividual, OWLObjectPropertyAssertionAxiom, OWLObjectPropertyIndividualPair>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLObjectPropertyAssertionAxiom) {
            return ((OWLObjectPropertyAssertionAxiom)axiom).getSubject().equals(this.getRootObject());
        }
        return false;
    }
}

