/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.Comparator;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectPropertyIndividualPairEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLObjectPropertyIndividualPair;
import org.protege.editor.owl.ui.frame.individual.OWLNegativeObjectPropertyAssertionFrameSectionRow;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLNegativeObjectPropertyAssertionFrameSection
extends AbstractOWLFrameSection<OWLIndividual, OWLNegativeObjectPropertyAssertionAxiom, OWLObjectPropertyIndividualPair> {
    public static final String LABEL = "Negative object property assertions";

    @Override
    protected void clear() {
    }

    public OWLNegativeObjectPropertyAssertionFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLIndividual> frame) {
        super(editorKit, LABEL, "Negative object property assertion", frame);
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLNegativeObjectPropertyAssertionAxiom ax : ontology.getNegativeObjectPropertyAssertionAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLNegativeObjectPropertyAssertionFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLIndividual)this.getRootObject(), ax));
        }
    }

    @Override
    protected OWLNegativeObjectPropertyAssertionAxiom createAxiom(OWLObjectPropertyIndividualPair object) {
        return this.getOWLDataFactory().getOWLNegativeObjectPropertyAssertionAxiom(object.getProperty(), (OWLIndividual)this.getRootObject(), object.getIndividual());
    }

    @Override
    public OWLObjectEditor<OWLObjectPropertyIndividualPair> getObjectEditor() {
        return new OWLObjectPropertyIndividualPairEditor(this.getOWLEditorKit());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLIndividual, OWLNegativeObjectPropertyAssertionAxiom, OWLObjectPropertyIndividualPair>> getRowComparator() {
        return null;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        if (!change.isAxiomChange()) {
            return false;
        }
        OWLAxiom axiom = change.getAxiom();
        if (axiom instanceof OWLNegativeObjectPropertyAssertionAxiom) {
            return ((OWLNegativeObjectPropertyAssertionAxiom)axiom).getSubject().equals(this.getRootObject());
        }
        return false;
    }
}

