/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame.individual;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.frame.individual.OWLClassAssertionAxiomTypeFrameSectionRow;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLClassAssertionAxiomTypeFrameSection
extends AbstractOWLFrameSection<OWLIndividual, OWLClassAssertionAxiom, OWLClassExpression> {
    private static final Logger logger = Logger.getLogger(OWLClassAssertionAxiomTypeFrameSection.class);
    public static final String LABEL = "Types";
    private Set<OWLClassExpression> added = new HashSet<OWLClassExpression>();

    public OWLClassAssertionAxiomTypeFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLIndividual> frame) {
        super(editorKit, LABEL, "Type assertion", frame);
    }

    @Override
    protected void clear() {
        this.added.clear();
    }

    @Override
    protected void refill(OWLOntology ontology) {
        for (OWLClassAssertionAxiom ax : ontology.getClassAssertionAxioms((OWLIndividual)this.getRootObject())) {
            this.addRow(new OWLClassAssertionAxiomTypeFrameSectionRow(this.getOWLEditorKit(), this, ontology, (OWLIndividual)this.getRootObject(), ax));
            this.added.add(ax.getClassExpression());
        }
    }

    @Override
    protected void refillInferred() {
        this.getOWLModelManager().getReasonerPreferences().executeTask(ReasonerPreferences.OptionalInferenceTask.SHOW_INFERRED_TYPES, new Runnable(){

            @Override
            public void run() {
                if (!OWLClassAssertionAxiomTypeFrameSection.this.getOWLModelManager().getReasoner().isConsistent()) {
                    return;
                }
                if (!((OWLIndividual)OWLClassAssertionAxiomTypeFrameSection.this.getRootObject()).isAnonymous()) {
                    for (OWLClass inferredType : OWLClassAssertionAxiomTypeFrameSection.this.getReasoner().getTypes(((OWLIndividual)OWLClassAssertionAxiomTypeFrameSection.this.getRootObject()).asOWLNamedIndividual(), true).getFlattened()) {
                        if (OWLClassAssertionAxiomTypeFrameSection.this.added.contains(inferredType)) continue;
                        OWLClassAssertionAxiom ax = OWLClassAssertionAxiomTypeFrameSection.this.getOWLDataFactory().getOWLClassAssertionAxiom((OWLClassExpression)inferredType, (OWLIndividual)OWLClassAssertionAxiomTypeFrameSection.this.getRootObject());
                        OWLClassAssertionAxiomTypeFrameSection.this.addRow(new OWLClassAssertionAxiomTypeFrameSectionRow(OWLClassAssertionAxiomTypeFrameSection.this.getOWLEditorKit(), OWLClassAssertionAxiomTypeFrameSection.this, null, (OWLIndividual)OWLClassAssertionAxiomTypeFrameSection.this.getRootObject(), ax));
                        OWLClassAssertionAxiomTypeFrameSection.this.added.add(inferredType);
                    }
                }
            }
        });
    }

    @Override
    protected OWLClassAssertionAxiom createAxiom(OWLClassExpression classExpression) {
        return this.getOWLDataFactory().getOWLClassAssertionAxiom(classExpression, (OWLIndividual)this.getRootObject());
    }

    @Override
    public OWLObjectEditor<OWLClassExpression> getObjectEditor() {
        return this.getOWLEditorKit().getWorkspace().getOWLComponentFactory().getOWLClassDescriptionEditor(null, AxiomType.CLASS_ASSERTION);
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLClassExpression) {
                OWLClassExpression classExpression = (OWLClassExpression)obj;
                OWLClassAssertionAxiom ax = this.getOWLDataFactory().getOWLClassAssertionAxiom(classExpression, (OWLIndividual)this.getRootObject());
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLIndividual, OWLClassAssertionAxiom, OWLClassExpression>> getRowComparator() {
        return new Comparator<OWLFrameSectionRow<OWLIndividual, OWLClassAssertionAxiom, OWLClassExpression>>(){
            private Comparator<OWLObject> comparator;
            {
                this.comparator = OWLClassAssertionAxiomTypeFrameSection.this.getOWLModelManager().getOWLObjectComparator();
            }

            @Override
            public int compare(OWLFrameSectionRow<OWLIndividual, OWLClassAssertionAxiom, OWLClassExpression> o1, OWLFrameSectionRow<OWLIndividual, OWLClassAssertionAxiom, OWLClassExpression> o2) {
                if (o1.isInferred() && !o2.isInferred()) {
                    return 1;
                }
                if (o2.isInferred() && !o1.isInferred()) {
                    return -1;
                }
                return this.comparator.compare((OWLObject)o1.getAxiom().getClassExpression(), (OWLObject)o2.getAxiom().getClassExpression());
            }
        };
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLClassAssertionAxiom && ((OWLClassAssertionAxiom)change.getAxiom()).getIndividual().equals(this.getRootObject());
    }
}

