/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.editor.OWLAnnotationEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.OWLAnnotationsFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class OWLAnnotationFrameSection
extends AbstractOWLFrameSection<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation> {
    private static final String LABEL = "Annotations";
    private static OWLAnnotationSectionRowComparator comparator;

    public OWLAnnotationFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLAnnotationSubject> frame) {
        super(editorKit, LABEL, "Entity annotation", frame);
        comparator = new OWLAnnotationSectionRowComparator(editorKit.getModelManager());
    }

    @Override
    protected void clear() {
    }

    @Override
    protected void refill(OWLOntology ontology) {
        boolean hidden = false;
        OWLAnnotationSubject annotationSubject = (OWLAnnotationSubject)this.getRootObject();
        for (OWLAnnotationAssertionAxiom ax : ontology.getAnnotationAssertionAxioms(annotationSubject)) {
            if (!this.getOWLEditorKit().getWorkspace().isHiddenAnnotationURI(ax.getAnnotation().getProperty().getIRI().toURI())) {
                this.addRow(new OWLAnnotationsFrameSectionRow(this.getOWLEditorKit(), this, ontology, annotationSubject, ax));
                continue;
            }
            hidden = true;
        }
        if (hidden) {
            this.setLabel("Annotations (some annotations are hidden)");
        } else {
            this.setLabel(LABEL);
        }
    }

    @Override
    protected OWLAnnotationAssertionAxiom createAxiom(OWLAnnotation object) {
        return this.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.getRootObject(), object);
    }

    @Override
    public OWLObjectEditor<OWLAnnotation> getObjectEditor() {
        return new OWLAnnotationEditor(this.getOWLEditorKit());
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation>> getRowComparator() {
        return comparator;
    }

    @Override
    public boolean canAcceptDrop(List<OWLObject> objects) {
        for (OWLObject obj : objects) {
            if (obj instanceof OWLAnnotation) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean dropObjects(List<OWLObject> objects) {
        ArrayList<AddAxiom> changes = new ArrayList<AddAxiom>();
        for (OWLObject obj : objects) {
            if (obj instanceof OWLAnnotation) {
                OWLAnnotation annot = (OWLAnnotation)obj;
                OWLAnnotationAssertionAxiom ax = this.getOWLDataFactory().getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)this.getRootObject(), annot);
                changes.add(new AddAxiom(this.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
                continue;
            }
            return false;
        }
        this.getOWLModelManager().applyChanges(changes);
        return true;
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return change.isAxiomChange() && change.getAxiom() instanceof OWLAnnotationAssertionAxiom && ((OWLAnnotationAssertionAxiom)change.getAxiom()).getSubject().equals(this.getRootObject());
    }

    private static class OWLAnnotationSectionRowComparator
    implements Comparator<OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation>> {
        private Comparator<OWLObject> owlObjectComparator;

        public OWLAnnotationSectionRowComparator(OWLModelManager owlModelManager) {
            this.owlObjectComparator = owlModelManager.getOWLObjectComparator();
        }

        @Override
        public int compare(OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation> o1, OWLFrameSectionRow<OWLAnnotationSubject, OWLAnnotationAssertionAxiom, OWLAnnotation> o2) {
            OWLAnnotation annotation1 = o1.getAxiom().getAnnotation();
            OWLAnnotation annotation2 = o2.getAxiom().getAnnotation();
            return this.getAnnotationDifference(annotation1, annotation2);
        }

        private int getAnnotationDifference(OWLAnnotation annotation1, OWLAnnotation annotation2) {
            int diff = this.getAnnotationPropertyDifference(annotation1.getProperty(), annotation2.getProperty());
            if (diff == 0) {
                diff = this.getAnnotationLanguageDifference(annotation1.getValue(), annotation2.getValue());
            }
            if (diff == 0) {
                diff = this.getAnnotationValueDifference(annotation1.getValue(), annotation2.getValue());
            }
            return diff;
        }

        private int getAnnotationPropertyDifference(OWLAnnotationProperty property1, OWLAnnotationProperty property2) {
            OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
            List<IRI> annotationIRIs = preferences.getAnnotationIRIs();
            int index1 = annotationIRIs.indexOf(property1.getIRI());
            int index2 = annotationIRIs.indexOf(property2.getIRI());
            int diff = 0;
            if (index1 != -1 && index2 != -1) {
                diff = index1 - index2;
            }
            if (diff == 0) {
                if (property1.isLabel()) {
                    if (!property2.isLabel()) {
                        diff = -1;
                    }
                } else if (property2.isLabel()) {
                    diff = 1;
                }
            }
            if (diff == 0) {
                diff = this.owlObjectComparator.compare((OWLObject)property1, (OWLObject)property2);
            }
            return diff;
        }

        private int getAnnotationLanguageDifference(OWLAnnotationValue value1, OWLAnnotationValue value2) {
            int diff = 0;
            if (value1 instanceof OWLLiteral && value2 instanceof OWLLiteral) {
                OWLLiteral lit1 = (OWLLiteral)value1;
                String lang1 = lit1.getLang();
                OWLLiteral lit2 = (OWLLiteral)value2;
                String lang2 = lit2.getLang();
                List<String> langs = OWLRendererPreferences.getInstance().getAnnotationLangs();
                int langIndex1 = langs.indexOf(lang1);
                int langIndex2 = langs.indexOf(lang2);
                diff = langIndex1 == -1 ? 1 : (langIndex2 == -1 ? -1 : langIndex1 - langIndex2);
            }
            return diff;
        }

        private int getAnnotationValueDifference(OWLAnnotationValue value1, OWLAnnotationValue value2) {
            return this.owlObjectComparator.compare((OWLObject)value1, (OWLObject)value2);
        }
    }
}

