/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.frame;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.TreeSet;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.frame.AbstractOWLFrameSection;
import org.protege.editor.owl.ui.frame.InferredAxiomsFrameSectionRow;
import org.protege.editor.owl.ui.frame.OWLFrame;
import org.protege.editor.owl.ui.frame.OWLFrameSectionRow;
import org.semanticweb.owlapi.apibinding.OWLManager;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.InferredAxiomGenerator;
import org.semanticweb.owlapi.util.InferredClassAssertionAxiomGenerator;
import org.semanticweb.owlapi.util.InferredOntologyGenerator;
import org.semanticweb.owlapi.util.InferredSubClassAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubDataPropertyAxiomGenerator;
import org.semanticweb.owlapi.util.InferredSubObjectPropertyAxiomGenerator;

public class InferredAxiomsFrameSection
extends AbstractOWLFrameSection<OWLOntology, OWLAxiom, OWLAxiom> {
    public InferredAxiomsFrameSection(OWLEditorKit editorKit, OWLFrame<? extends OWLOntology> frame) {
        super(editorKit, "Inferred axioms", "Inferred axiom", frame);
    }

    @Override
    protected void clear() {
    }

    @Override
    protected OWLAxiom createAxiom(OWLAxiom object) {
        return object;
    }

    @Override
    public OWLObjectEditor<OWLAxiom> getObjectEditor() {
        return null;
    }

    @Override
    protected void refill(OWLOntology ontology) {
    }

    @Override
    protected void refillInferred() {
        try {
            for (OWLClass cls : this.getReasoner().getUnsatisfiableClasses()) {
                if (cls.isOWLNothing()) continue;
                OWLSubClassOfAxiom unsatAx = this.getOWLDataFactory().getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)this.getOWLDataFactory().getOWLNothing());
                this.addRow(new InferredAxiomsFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLOntology)this.getRootObject(), (OWLAxiom)unsatAx));
            }
            OWLOntologyManager man = OWLManager.createOWLOntologyManager();
            OWLOntology inferredOnt = man.createOntology(IRI.create((String)("http://another.com/ontology" + System.currentTimeMillis())));
            InferredOntologyGenerator ontGen = new InferredOntologyGenerator(this.getOWLModelManager().getReasoner(), new ArrayList());
            ontGen.addGenerator((InferredAxiomGenerator)new InferredSubClassAxiomGenerator());
            ontGen.addGenerator((InferredAxiomGenerator)new InferredClassAssertionAxiomGenerator());
            ontGen.addGenerator((InferredAxiomGenerator)new InferredSubObjectPropertyAxiomGenerator());
            ontGen.addGenerator((InferredAxiomGenerator)new InferredSubDataPropertyAxiomGenerator());
            ontGen.fillOntology(man, inferredOnt);
            for (OWLAxiom ax : new TreeSet(inferredOnt.getAxioms())) {
                boolean add = true;
                for (OWLOntology actOnt : this.getOWLModelManager().getActiveOntologies()) {
                    if (!actOnt.containsAxiom(ax)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                if (ax instanceof OWLSubClassOfAxiom) {
                    OWLSubClassOfAxiom subClsAx = (OWLSubClassOfAxiom)ax;
                    if (subClsAx.getSuperClass().isOWLThing()) continue;
                    this.addRow(new InferredAxiomsFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLOntology)this.getRootObject(), ax));
                    continue;
                }
                this.addRow(new InferredAxiomsFrameSectionRow(this.getOWLEditorKit(), this, null, (OWLOntology)this.getRootObject(), ax));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean isResettingChange(OWLOntologyChange change) {
        return false;
    }

    @Override
    public Comparator<OWLFrameSectionRow<OWLOntology, OWLAxiom, OWLAxiom>> getRowComparator() {
        return new Comparator<OWLFrameSectionRow<OWLOntology, OWLAxiom, OWLAxiom>>(){

            @Override
            public int compare(OWLFrameSectionRow<OWLOntology, OWLAxiom, OWLAxiom> o1, OWLFrameSectionRow<OWLOntology, OWLAxiom, OWLAxiom> o2) {
                int diff = o1.getAxiom().compareTo((Object)o2.getAxiom());
                if (diff != 0) {
                    return diff;
                }
                if (o1.getOntology() == null && o2.getOntology() == null) {
                    return 0;
                }
                if (o1.getOntology() == null) {
                    return -1;
                }
                if (o2.getOntology() == null) {
                    return 1;
                }
                return o1.getOntology().compareTo((Object)o2.getOntology());
            }
        };
    }
}

