/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.find;

import java.awt.Component;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.protege.editor.core.ui.util.AugmentedJTextField;
import org.protege.editor.core.ui.util.ComponentFactory;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.find.OWLEntityFinderPreferences;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class EntityFinderField
extends AugmentedJTextField {
    private static final long serialVersionUID = -5383341925424297227L;
    private OWLEditorKit editorKit;
    private JList resultsList;
    private JWindow window;
    private JComponent parent;
    private Timer timer = new Timer(400, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            EntityFinderField.this.executeFind();
            EntityFinderField.this.timer.stop();
        }
    });

    public EntityFinderField(JComponent parent, OWLEditorKit editorKit) {
        super(20, "Search for entity");
        this.putClientProperty("JTextField.variant", "search");
        this.parent = parent;
        this.editorKit = editorKit;
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    EntityFinderField.this.closeResults();
                }
                if (e.getKeyCode() == 10 && EntityFinderField.this.resultsList.getSelectedValue() instanceof OWLEntity) {
                    EntityFinderField.this.selectEntity();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38) {
                    EntityFinderField.this.decrementListSelection();
                }
                if (e.getKeyCode() == 40) {
                    EntityFinderField.this.incrementListSelection();
                }
            }
        });
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                EntityFinderField.this.performFind();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                EntityFinderField.this.performFind();
            }
        });
        this.resultsList = new JList();
        this.resultsList.setCellRenderer(editorKit.getWorkspace().createOWLCellRenderer());
        this.resultsList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getClickCount() == 2 && EntityFinderField.this.resultsList.getSelectedValue() instanceof OWLEntity) {
                    EntityFinderField.this.selectEntity();
                }
            }
        });
    }

    private void selectEntity() {
        OWLEntity selEntity = (OWLEntity)this.resultsList.getSelectedValue();
        if (selEntity != null) {
            this.closeResults();
            this.editorKit.getWorkspace().getOWLSelectionModel().setSelectedEntity(selEntity);
            this.editorKit.getWorkspace().displayOWLEntity(selEntity);
        }
    }

    private void incrementListSelection() {
        if (this.resultsList.getModel().getSize() > 0) {
            int selIndex = this.resultsList.getSelectedIndex();
            if (++selIndex > this.resultsList.getModel().getSize() - 1) {
                selIndex = 0;
            }
            this.resultsList.setSelectedIndex(selIndex);
            this.resultsList.scrollRectToVisible(this.resultsList.getCellBounds(selIndex, selIndex));
        }
    }

    private void decrementListSelection() {
        if (this.resultsList.getModel().getSize() > 0) {
            int selIndex = this.resultsList.getSelectedIndex();
            if (--selIndex < 0) {
                selIndex = this.resultsList.getModel().getSize() - 1;
            }
            this.resultsList.setSelectedIndex(selIndex);
            this.resultsList.scrollRectToVisible(this.resultsList.getCellBounds(selIndex, selIndex));
        }
    }

    private void closeResults() {
        this.getWindow().setVisible(false);
        this.resultsList.setListData(new Object[0]);
    }

    private void executeFind() {
        if (this.getText().trim().length() > 0) {
            Set<OWLEntity> results = this.editorKit.getModelManager().getOWLEntityFinder().getMatchingOWLEntities(this.getText());
            this.showResults(results);
        } else {
            this.closeResults();
        }
    }

    private void performFind() {
        this.timer.setDelay((int)OWLEntityFinderPreferences.getInstance().getSearchDelay());
        this.timer.restart();
    }

    private JWindow getWindow() {
        if (this.window == null) {
            Window w = (Window)SwingUtilities.getAncestorOfClass(Window.class, this.parent);
            this.window = new JWindow(w);
            this.window.setFocusableWindowState(false);
            JScrollPane sp = ComponentFactory.createScrollPane((JComponent)this.resultsList);
            sp.setBorder(null);
            this.window.setContentPane(sp);
            this.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    EntityFinderField.this.window.setVisible(false);
                    EntityFinderField.this.resultsList.setListData(new Object[0]);
                }
            });
            SwingUtilities.getRoot((Component)((Object)this)).addComponentListener(new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent e) {
                    EntityFinderField.this.closeResults();
                }
            });
        }
        return this.window;
    }

    private void showResults(Set<OWLEntity> results) {
        JWindow window = this.getWindow();
        if (results.size() > 0) {
            Point pt = new Point(0, 0);
            SwingUtilities.convertPointToScreen(pt, (Component)((Object)this));
            window.setLocation(pt.x, pt.y + this.getHeight() + 2);
            window.setSize(this.getWidth(), 400);
            this.resultsList.setListData(this.getSortedResults(results));
            window.setVisible(true);
            window.validate();
            this.resultsList.setSelectedIndex(0);
        } else {
            this.resultsList.setListData(new Object[0]);
        }
    }

    private Object[] getSortedResults(Set<OWLEntity> results) {
        TreeSet<OWLObject> ts = new TreeSet<OWLObject>(this.editorKit.getModelManager().getOWLObjectComparator());
        ts.addAll(results);
        int maxSize = 150;
        boolean tooMany = ts.size() > maxSize;
        Object[] arrayResults = new Object[tooMany ? maxSize : ts.size()];
        int i = 0;
        for (OWLEntity oWLEntity : ts) {
            if (tooMany && i >= arrayResults.length - 1) break;
            arrayResults[i++] = oWLEntity;
        }
        if (tooMany) {
            arrayResults[maxSize - 1] = "More...";
        }
        return arrayResults;
    }
}

