/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation.io;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPluginInstance;
import org.protege.editor.owl.ui.frame.AxiomListFrame;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.protege.owlapi.inconsistent.Phase01;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;

public class ProtegeHeuristics
implements InconsistentOntologyPluginInstance {
    private static final String PARAGRAPH = "<p>";
    private JFrame explanations;
    private OWLEditorKit owlEditorKit;
    private Phase01 phase01;
    private boolean successfulExplanation = false;
    private List<AxiomListFrame> axiomListFrames = new ArrayList<AxiomListFrame>();

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
        for (AxiomListFrame frame : this.axiomListFrames) {
            frame.dispose();
        }
        this.axiomListFrames.clear();
    }

    @Override
    public void setup(OWLEditorKit editorKit) {
        this.owlEditorKit = editorKit;
    }

    @Override
    public void explain(OWLOntology ontology) {
        this.successfulExplanation = false;
        String cancelOption = "Cancel";
        this.phase01 = new Phase01();
        JProgressBar bar = new JProgressBar();
        bar.setIndeterminate(true);
        bar.setVisible(true);
        JOptionPane pane = new JOptionPane(bar, -1, 2, null, new Object[]{"Cancel"});
        final JDialog dialog = pane.createDialog((Component)((Object)this.owlEditorKit.getOWLWorkspace()), "Explanation in progress");
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OWLModelManager p4Manager = ProtegeHeuristics.this.owlEditorKit.getOWLModelManager();
                    ProtegeHeuristics.this.successfulExplanation = ProtegeHeuristics.this.phase01.run(p4Manager.getActiveOntology(), p4Manager.getOWLReasonerManager().getCurrentReasonerFactory().getReasonerFactory());
                }
                catch (OWLOntologyCreationException oce) {
                    ProtegeApplication.getErrorLog().logError((Throwable)oce);
                }
                finally {
                    dialog.dispose();
                }
                if (ProtegeHeuristics.this.successfulExplanation) {
                    ProtegeHeuristics.this.createGui();
                }
            }
        }, "Protege Explanation Thread").start();
        dialog.setVisible(true);
        if ("Cancel".equals(pane.getValue())) {
            this.phase01.cancel();
        }
    }

    private void createGui() {
        this.explanations = new JFrame("Experimental Prot\u00e9g\u00e9 Explanation Heuristics");
        JTabbedPane tabs = new JTabbedPane();
        String[] inconsistentIndividualsExplanation = new String[]{PARAGRAPH, "Double click on the individuals listed below to see an explanation of an inconsistency.", PARAGRAPH, "Each individual in the list below corresponds to a reason why the ontology is inconsistent.", PARAGRAPH};
        tabs.add("\"Bad\" Individuals", this.createEntityListPanel(inconsistentIndividualsExplanation, this.phase01.getInconsistentIndividuals()));
        String[] inconsistentClassesExplanation = new String[]{PARAGRAPH, "Double click on the classes listed below to see an explanation of an inconsistency.", PARAGRAPH, "These classes can be proved inconsistent but this may not be a reason why the ontology is inconsistent.", PARAGRAPH};
        tabs.add("Inconsistent Classes", this.createEntityListPanel(inconsistentClassesExplanation, this.phase01.getInconsistentClasses()));
        String[] hotSpotExplanation = new String[]{PARAGRAPH, "The axioms listed below are likely to be involved in an explanation of an inconsistency.", PARAGRAPH, "In particular, if the ontology contains no individuals then any explanation of why the ontology is ", "inconsistent must include one of the axioms listed below.", PARAGRAPH};
        tabs.add("Hot spots", this.createHotspotList(hotSpotExplanation));
        this.explanations.setPreferredSize(new Dimension(900, 600));
        this.explanations.getContentPane().add(tabs);
        this.explanations.pack();
        this.explanations.setVisible(true);
        this.explanations.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                try {
                    ProtegeHeuristics.this.dispose();
                }
                catch (Exception ex) {
                    ProtegeApplication.getErrorLog().logError((Throwable)ex);
                }
            }
        });
    }

    private <X> JComponent createEntityListPanel(String[] explanations, Set<X> entities) {
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.buildExplanationsPanel(explanations), "North");
        int tall = 12000;
        JPanel frameListPanel = new JPanel();
        frameListPanel.setLayout(new BoxLayout(frameListPanel, 1));
        JLabel frameListLabel = new JLabel();
        frameListPanel.add(frameListLabel);
        AxiomListFrame frame = new AxiomListFrame(this.owlEditorKit);
        this.axiomListFrames.add(frame);
        OWLFrameList<Set<OWLAxiom>> frameList = new OWLFrameList<Set<OWLAxiom>>(this.owlEditorKit, frame);
        frameList.setPreferredSize(new Dimension(700, tall));
        frameList.setMaximumSize(new Dimension(tall, tall));
        frameList.refreshComponent();
        frameListPanel.add((Component)((Object)frameList));
        JPanel leftToRight = new JPanel();
        leftToRight.setLayout(new BoxLayout(leftToRight, 0));
        JComponent individualsList = this.createTitledEntityList(entities.toArray(), frameList, frameListLabel);
        individualsList.setPreferredSize(new Dimension(300, tall));
        leftToRight.add(individualsList);
        leftToRight.add(frameListPanel);
        panel.add((Component)leftToRight, "Center");
        return panel;
    }

    private JComponent createTitledEntityList(Object[] objects, OWLFrameList<Set<OWLAxiom>> frameList, JLabel frameListLabel) {
        final JList<Object> entitiesList = new JList<Object>(objects);
        entitiesList.setCellRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = -8027034437907937901L;

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)entitiesList, value, index, isSelected, cellHasFocus);
                if (value instanceof OWLEntity) {
                    label.setText(ProtegeHeuristics.this.owlEditorKit.getOWLModelManager().getRendering((OWLObject)((OWLEntity)value)));
                }
                return label;
            }
        });
        entitiesList.addListSelectionListener(new SynchronizeSelectionListener(entitiesList));
        entitiesList.addMouseListener(new ExplainEntityMouseAdapter(entitiesList, frameList, frameListLabel));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.getViewport().add(entitiesList);
        return scrollPane;
    }

    private JComponent createHotspotList(String[] explanations) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildExplanationsPanel(explanations), "North");
        int tall = 12000;
        AxiomListFrame frame = new AxiomListFrame(this.owlEditorKit);
        this.axiomListFrames.add(frame);
        OWLFrameList<Set<OWLAxiom>> frameList = new OWLFrameList<Set<OWLAxiom>>(this.owlEditorKit, frame);
        frameList.setPreferredSize(new Dimension(700, tall));
        frameList.setMaximumSize(new Dimension(tall, tall));
        frameList.refreshComponent();
        frameList.setRootObject(this.phase01.getHotspots().getAxioms());
        panel.add((Component)((Object)frameList), "Center");
        return panel;
    }

    private JComponent buildExplanationsPanel(String[] explanations) {
        JPanel explanationPanel = new JPanel();
        explanationPanel.setLayout(new BoxLayout(explanationPanel, 1));
        for (String explanation : explanations) {
            if (explanation.equals(PARAGRAPH)) {
                explanationPanel.add(Box.createVerticalStrut(5));
                continue;
            }
            JLabel label = new JLabel(explanation);
            label.setAlignmentY(0.0f);
            explanationPanel.add(label);
        }
        return explanationPanel;
    }

    private class ExplainEntityMouseAdapter
    extends MouseAdapter {
        private JList entitiesList;
        private OWLFrameList<Set<OWLAxiom>> frameList;
        private JLabel frameListLabel;

        public ExplainEntityMouseAdapter(JList entitiesList, OWLFrameList<Set<OWLAxiom>> frameList, JLabel frameListLabel) {
            this.entitiesList = entitiesList;
            this.frameList = frameList;
            this.frameListLabel = frameListLabel;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            Object o = this.entitiesList.getSelectedValue();
            if (event.getClickCount() == 2) {
                Set axioms = null;
                if (o instanceof OWLIndividual) {
                    OWLIndividual i = (OWLIndividual)o;
                    axioms = ProtegeHeuristics.this.phase01.explain(i);
                    String rendering = ProtegeHeuristics.this.owlEditorKit.getOWLModelManager().getRendering((OWLObject)i);
                    this.frameListLabel.setText("Inconsistency derived from axioms about " + rendering);
                } else if (o instanceof OWLClass) {
                    OWLClass c = (OWLClass)o;
                    axioms = ProtegeHeuristics.this.phase01.explain(c);
                    String rendering = ProtegeHeuristics.this.owlEditorKit.getOWLModelManager().getRendering((OWLObject)c);
                    this.frameListLabel.setText("Why " + rendering + " is inconsistent.");
                } else {
                    return;
                }
                this.frameList.setRootObject(axioms);
                this.frameList.refreshComponent();
            }
        }
    }

    private class SynchronizeSelectionListener
    implements ListSelectionListener {
        private JList entitiesList;

        public SynchronizeSelectionListener(JList entitiesList) {
            this.entitiesList = entitiesList;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            Object o = this.entitiesList.getSelectedValue();
            if (o instanceof OWLEntity) {
                ProtegeHeuristics.this.owlEditorKit.getOWLWorkspace().getOWLSelectionModel().setSelectedEntity((OWLEntity)o);
            }
        }
    }
}

