/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation.io;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLEditorKitHook;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPlugin;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyPluginInstance;
import org.protege.editor.owl.ui.explanation.io.IntroductoryPanel;

public class InconsistentOntologyManager
extends OWLEditorKitHook {
    public static final Logger LOGGER = Logger.getLogger(InconsistentOntologyManager.class);
    public static final String EXPLAIN = "Explain";
    private OWLEditorKit owlEditorKit;
    private InconsistentOntologyPlugin lastSelectedPlugin;
    private List<InconsistentOntologyPluginInstance> explanations = new ArrayList<InconsistentOntologyPluginInstance>();

    public static InconsistentOntologyManager get(OWLModelManager modelManager) {
        return (InconsistentOntologyManager)modelManager.get(InconsistentOntologyManager.class);
    }

    public void setup(EditorKit editorKit) {
        this.owlEditorKit = (OWLEditorKit)editorKit;
        OWLModelManager p4Manager = this.owlEditorKit.getModelManager();
        p4Manager.put(InconsistentOntologyManager.class, (Disposable)this);
    }

    public void explain() {
        try {
            Object[] options = new Object[]{EXPLAIN, "Cancel"};
            IntroductoryPanel intro = new IntroductoryPanel(this.owlEditorKit, this.lastSelectedPlugin);
            int ret = JOptionPane.showOptionDialog((Component)((Object)this.owlEditorKit.getOWLWorkspace()), intro, "Help for inconsistent ontologies", 1, 3, null, options, EXPLAIN);
            if (ret == 0) {
                this.lastSelectedPlugin = intro.getSelectedPlugin();
                InconsistentOntologyPluginInstance i = this.lastSelectedPlugin.newInstance();
                i.setup(this.owlEditorKit);
                i.explain(this.owlEditorKit.getOWLModelManager().getActiveOntology());
                this.explanations.add(i);
            }
        }
        catch (Exception ioe) {
            ProtegeApplication.getErrorLog().logError((Throwable)ioe);
        }
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
        for (InconsistentOntologyPluginInstance e : this.explanations) {
            e.dispose();
        }
        this.explanations.clear();
    }
}

