/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation.impl;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Set;
import javax.swing.JScrollPane;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.protege.editor.owl.ui.explanation.impl.BasicClassExpressionGenerator;
import org.protege.editor.owl.ui.frame.AxiomListFrame;
import org.protege.editor.owl.ui.framelist.OWLFrameList;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;

public class BasicBlackboxExplanationService
extends ExplanationService {
    @Override
    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }

    @Override
    public boolean hasExplanation(OWLAxiom axiom) {
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        if (activeOntology.containsAxiom(axiom, true)) {
            return false;
        }
        return this.getClassExpression(axiom) != null;
    }

    @Override
    public ExplanationResult explain(OWLAxiom axiom) {
        OWLOntology activeOntology = this.getOWLModelManager().getActiveOntology();
        OWLReasonerFactory rFactory = this.getOWLModelManager().getOWLReasonerManager().getCurrentReasonerFactory().getReasonerFactory();
        OWLReasoner reasoner = this.getOWLModelManager().getOWLReasonerManager().getCurrentReasoner();
        BlackBoxExplanation explain = new BlackBoxExplanation(activeOntology, rFactory, reasoner);
        Set axioms = explain.getExplanation(this.getClassExpression(axiom));
        AxiomListFrame frame = new AxiomListFrame(this.getOWLEditorKit());
        frame.setRootObject(axioms);
        final OWLFrameList<Set<OWLAxiom>> frameList = new OWLFrameList<Set<OWLAxiom>>(this.getOWLEditorKit(), frame);
        frameList.setPreferredSize(new Dimension(800, 600));
        frameList.refreshComponent();
        ExplanationResult result = new ExplanationResult(){

            @Override
            public void dispose() {
                frameList.dispose();
            }
        };
        result.setLayout(new BorderLayout());
        result.add((Component)new JScrollPane((Component)((Object)frameList)), "Center");
        return result;
    }

    private OWLClassExpression getClassExpression(OWLAxiom axiom) {
        BasicClassExpressionGenerator classExpressionVisitor = new BasicClassExpressionGenerator(this.getOWLModelManager().getOWLDataFactory());
        axiom.accept((OWLAxiomVisitor)classExpressionVisitor);
        return classExpressionVisitor.getDebuggerClassExpression();
    }
}

