/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.Frame;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import org.apache.log4j.Logger;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.explanation.ExplanationDialog;
import org.protege.editor.owl.ui.explanation.ExplanationPlugin;
import org.protege.editor.owl.ui.explanation.ExplanationPluginLoader;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public class ExplanationManager {
    private static Logger logger = Logger.getLogger(ExplanationManager.class);
    private OWLEditorKit editorKit;
    private Collection<ExplanationService> explainers = new HashSet<ExplanationService>();

    public ExplanationManager(OWLEditorKit editorKit) {
        this.editorKit = editorKit;
        this.reload();
    }

    public void reload() {
        ExplanationPluginLoader loader = new ExplanationPluginLoader(this.editorKit);
        this.explainers.clear();
        for (ExplanationPlugin plugin : loader.getPlugins()) {
            ExplanationService teacher = null;
            try {
                teacher = plugin.newInstance();
                teacher.initialise();
                this.explainers.add(teacher);
            }
            catch (Exception e) {
                logger.warn((Object)("Exception caught initialising explanation service " + plugin.getName() + " - skipping..."), (Throwable)e);
            }
        }
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.editorKit;
    }

    public OWLModelManager getModelManager() {
        return this.editorKit.getModelManager();
    }

    public Collection<ExplanationService> getExplainers() {
        return this.explainers;
    }

    public Collection<ExplanationService> getTeachers(OWLAxiom axiom) {
        HashSet<ExplanationService> smartTeachers = new HashSet<ExplanationService>();
        for (ExplanationService teacher : this.explainers) {
            if (!teacher.hasExplanation(axiom)) continue;
            smartTeachers.add(teacher);
        }
        return smartTeachers;
    }

    public boolean hasExplanation(OWLAxiom axiom) {
        for (ExplanationService teacher : this.explainers) {
            if (!teacher.hasExplanation(axiom)) continue;
            return true;
        }
        return false;
    }

    public void handleExplain(Frame owner, OWLAxiom axiom) {
        Collection<ExplanationService> teachers = this.getTeachers(axiom);
        final ExplanationDialog explanation = new ExplanationDialog(owner, this, axiom);
        JOptionPane op = new JOptionPane(explanation, -1, -1);
        JDialog dlg = op.createDialog(owner, this.getExplanationDialogTitle(axiom));
        dlg.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                explanation.dispose();
            }
        });
        dlg.setDefaultCloseOperation(2);
        dlg.setModal(false);
        dlg.setResizable(true);
        dlg.pack();
        dlg.setVisible(true);
    }

    private String getExplanationDialogTitle(OWLAxiom entailment) {
        String rendering = this.editorKit.getOWLModelManager().getRendering((OWLObject)entailment).replaceAll("\\s", " ");
        return "Explanation for " + rendering;
    }
}

