/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.explanation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.explanation.ExplanationResult;
import org.protege.editor.owl.ui.explanation.ExplanationService;
import org.semanticweb.owlapi.model.OWLAxiom;

public class ExplanationDialog
extends JPanel {
    private static final long serialVersionUID = -4476549896762790748L;
    public static final String PREFERENCES_SET_KEY = "EXPLANATION_PREFS_SET";
    public static final String DEFAULT_EXPLANATION_ID = "PREFERRED_PLUGIN_ID";
    private JPanel explanationContainer;
    private ExplanationResult explanation;
    private OWLAxiom axiom;

    public ExplanationDialog(Frame owner, ExplanationManager explanationManager, OWLAxiom axiom) {
        this.axiom = axiom;
        this.setLayout(new BorderLayout());
        Collection<ExplanationService> teachers = explanationManager.getTeachers(axiom);
        if (teachers.size() == 1) {
            this.explanation = teachers.iterator().next().explain(axiom);
        } else {
            JComboBox selector = this.createComboBox(teachers);
            this.add((Component)selector, "North");
        }
        this.explanationContainer = new JPanel();
        this.explanationContainer.setLayout(new BoxLayout(this.explanationContainer, 1));
        this.explanationContainer.add(this.explanation);
        this.add((Component)this.explanationContainer, "Center");
    }

    private JComboBox createComboBox(Collection<ExplanationService> teachers) {
        ExplanationService[] teacherArray = teachers.toArray(new ExplanationService[0]);
        final JComboBox<ExplanationService> selector = new JComboBox<ExplanationService>(teacherArray);
        ExplanationService selected = teacherArray[0];
        String id = this.getDefaultPluginId();
        if (id != null) {
            for (ExplanationService t : teachers) {
                if (!id.equals(t.getPluginId())) continue;
                selected = t;
            }
        }
        selector.setSelectedItem(selected);
        this.explanation = selected.explain(this.axiom);
        selector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExplanationService t = (ExplanationService)selector.getSelectedItem();
                ExplanationDialog.this.setDefaultPluginId(t.getPluginId());
                ExplanationDialog.this.explanationContainer.removeAll();
                if (ExplanationDialog.this.explanation != null) {
                    ExplanationDialog.this.explanation.dispose();
                }
                ExplanationDialog.this.explanation = t.explain(ExplanationDialog.this.axiom);
                ExplanationDialog.this.explanationContainer.add(ExplanationDialog.this.explanation);
                ExplanationDialog.this.revalidate();
            }
        });
        return selector;
    }

    public String getDefaultPluginId() {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        Preferences prefs = prefMan.getPreferencesForSet(PREFERENCES_SET_KEY, ReasonerPreferences.class);
        return prefs.getString(DEFAULT_EXPLANATION_ID, null);
    }

    public void setDefaultPluginId(String id) {
        PreferencesManager prefMan = PreferencesManager.getInstance();
        Preferences prefs = prefMan.getPreferencesForSet(PREFERENCES_SET_KEY, ReasonerPreferences.class);
        prefs.putString(DEFAULT_EXPLANATION_ID, id);
    }

    public void dispose() {
        if (this.explanation != null) {
            this.explanation.dispose();
        }
    }
}

