/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.ui.clsdescriptioneditor.ExpressionEditor;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SWRLRule;

public class SWRLRuleEditor
extends AbstractOWLObjectEditor<SWRLRule>
implements VerifiedInputEditor {
    private OWLModelManager mngr;
    private ExpressionEditor<SWRLRule> editor;
    private JScrollPane scrollpane;

    public SWRLRuleEditor(OWLEditorKit editorKit) {
        OWLExpressionCheckerFactory fac = editorKit.getModelManager().getOWLExpressionCheckerFactory();
        this.editor = new ExpressionEditor<SWRLRule>(editorKit, fac.getSWRLChecker());
        this.scrollpane = new JScrollPane(this.editor);
        this.scrollpane.setPreferredSize(new Dimension(500, 200));
        this.mngr = editorKit.getModelManager();
    }

    @Override
    public String getEditorTypeName() {
        return "SWRL Rule";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof SWRLRule;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.scrollpane;
    }

    @Override
    public SWRLRule getEditedObject() {
        try {
            return this.editor.createObject();
        }
        catch (OWLException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean setEditedObject(SWRLRule rule) {
        if (rule == null) {
            this.editor.setText("");
        } else {
            this.editor.setText(this.mngr.getRendering((OWLObject)rule));
        }
        return true;
    }

    @Override
    public void dispose() {
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.addStatusChangedListener(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.editor.removeStatusChangedListener(listener);
    }
}

