/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.ui.editor.AbstractRestrictionCreatorPanel;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.selector.AbstractSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLClassSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class OWLObjectRestrictionCreatorPanel
extends AbstractRestrictionCreatorPanel<OWLObjectProperty, OWLClass> {
    private AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass> some;
    private AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass> only;
    private AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLObjectProperty, OWLClass> min;
    private AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLObjectProperty, OWLClass> exactly;
    private AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLObjectProperty, OWLClass> max;

    @Override
    protected List<AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass>> createTypes() {
        ArrayList<AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass>> types = new ArrayList<AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass>>();
        this.some = new AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass>("Some (existential)"){

            @Override
            public void createRestrictions(Set<OWLObjectProperty> properties, Set<OWLClass> fillers, Set<OWLClassExpression> result) {
                for (OWLObjectProperty prop : properties) {
                    for (OWLClass filler : fillers) {
                        result.add((OWLClassExpression)OWLObjectRestrictionCreatorPanel.this.getDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)prop, (OWLClassExpression)filler));
                    }
                }
            }
        };
        types.add(this.some);
        this.only = new AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass>("Only (universal)"){

            @Override
            public void createRestrictions(Set<OWLObjectProperty> properties, Set<OWLClass> fillers, Set<OWLClassExpression> result) {
                for (OWLObjectProperty prop : properties) {
                    if (fillers.isEmpty()) {
                        return;
                    }
                    Object filler = fillers.size() > 1 ? OWLObjectRestrictionCreatorPanel.this.getDataFactory().getOWLObjectUnionOf(fillers) : (OWLClassExpression)fillers.iterator().next();
                    result.add((OWLClassExpression)OWLObjectRestrictionCreatorPanel.this.getDataFactory().getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)prop, filler));
                }
            }
        };
        types.add(this.only);
        this.min = new AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLObjectProperty, OWLClass>("Min (min cardinality)"){

            @Override
            public OWLClassExpression createRestriction(OWLObjectProperty prop, OWLClass filler, int card) {
                return OWLObjectRestrictionCreatorPanel.this.getDataFactory().getOWLObjectMinCardinality(card, (OWLObjectPropertyExpression)prop, (OWLClassExpression)filler);
            }
        };
        types.add(this.min);
        this.exactly = new AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLObjectProperty, OWLClass>("Exactly (exact cardinality)"){

            @Override
            public OWLClassExpression createRestriction(OWLObjectProperty prop, OWLClass filler, int card) {
                return OWLObjectRestrictionCreatorPanel.this.getDataFactory().getOWLObjectExactCardinality(card, (OWLObjectPropertyExpression)prop, (OWLClassExpression)filler);
            }
        };
        types.add(this.exactly);
        this.max = new AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLObjectProperty, OWLClass>("Max (max cardinality)"){

            @Override
            public OWLClassExpression createRestriction(OWLObjectProperty prop, OWLClass filler, int card) {
                return OWLObjectRestrictionCreatorPanel.this.getDataFactory().getOWLObjectMaxCardinality(card, (OWLObjectPropertyExpression)prop, (OWLClassExpression)filler);
            }
        };
        types.add(this.max);
        return types;
    }

    @Override
    protected AbstractSelectorPanel<OWLClass> createFillerSelectorPanel() {
        return new OWLClassSelectorPanel(this.getOWLEditorKit());
    }

    @Override
    protected AbstractHierarchySelectorPanel<OWLObjectProperty> createPropertySelectorPanel() {
        return new OWLObjectPropertySelectorPanel(this.getOWLEditorKit());
    }

    @Override
    public boolean setDescription(OWLClassExpression description) {
        if (description == null) {
            return true;
        }
        AcceptableExpressionFilter filter = new AcceptableExpressionFilter();
        description.accept((OWLClassExpressionVisitor)filter);
        if (filter.isAcceptable) {
            this.setProperty(filter.p);
            this.setFiller(filter.f);
            this.setType(filter.t);
            if (filter.cardinality >= 0) {
                this.setCardinality(filter.cardinality);
            }
            return true;
        }
        return false;
    }

    class AcceptableExpressionFilter
    extends OWLClassExpressionVisitorAdapter {
        private boolean isAcceptable = false;
        private OWLObjectProperty p;
        private OWLClass f;
        private AbstractRestrictionCreatorPanel.RestrictionCreator<OWLObjectProperty, OWLClass> t;
        private int cardinality = -1;

        AcceptableExpressionFilter() {
        }

        private void handleRestriction(OWLQuantifiedRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression> r) {
            if (!((OWLObjectPropertyExpression)r.getProperty()).isAnonymous() && !((OWLClassExpression)r.getFiller()).isAnonymous()) {
                this.p = ((OWLObjectPropertyExpression)r.getProperty()).asOWLObjectProperty();
                this.f = ((OWLClassExpression)r.getFiller()).asOWLClass();
                this.isAcceptable = true;
            }
        }

        public void visit(OWLObjectSomeValuesFrom r) {
            this.t = OWLObjectRestrictionCreatorPanel.this.some;
            this.handleRestriction((OWLQuantifiedRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)r);
        }

        public void visit(OWLObjectAllValuesFrom r) {
            this.t = OWLObjectRestrictionCreatorPanel.this.only;
            this.handleRestriction((OWLQuantifiedRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)r);
        }

        public void visit(OWLObjectMinCardinality r) {
            this.t = OWLObjectRestrictionCreatorPanel.this.min;
            this.cardinality = r.getCardinality();
            this.handleRestriction((OWLQuantifiedRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)r);
        }

        public void visit(OWLObjectExactCardinality r) {
            this.t = OWLObjectRestrictionCreatorPanel.this.exactly;
            this.cardinality = r.getCardinality();
            this.handleRestriction((OWLQuantifiedRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)r);
        }

        public void visit(OWLObjectMaxCardinality r) {
            this.t = OWLObjectRestrictionCreatorPanel.this.max;
            this.cardinality = r.getCardinality();
            this.handleRestriction((OWLQuantifiedRestriction<OWLClassExpression, OWLObjectPropertyExpression, OWLClassExpression>)r);
        }
    }
}

