/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.awt.BorderLayout;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.frame.OWLObjectPropertyIndividualPair;
import org.protege.editor.owl.ui.selector.OWLIndividualSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyAssertionAxiom;

public class OWLObjectPropertyIndividualPairEditor
extends AbstractOWLObjectEditor<OWLObjectPropertyIndividualPair> {
    private JPanel editorPanel;
    private OWLObjectPropertySelectorPanel objectPropertyPanel;
    private OWLIndividualSelectorPanel individualSelectorPanel;

    public OWLObjectPropertyIndividualPairEditor(OWLEditorKit owlEditorKit) {
        this.objectPropertyPanel = new OWLObjectPropertySelectorPanel(owlEditorKit);
        this.individualSelectorPanel = new OWLIndividualSelectorPanel(owlEditorKit, 2);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(this.objectPropertyPanel);
        splitPane.setRightComponent(this.individualSelectorPanel);
        this.editorPanel = new JPanel(new BorderLayout());
        this.editorPanel.add(splitPane);
    }

    public void setObjectPropertyAxiom(OWLPropertyAssertionAxiom<OWLObjectPropertyExpression, OWLIndividual> ax) {
        OWLObjectPropertyExpression p = (OWLObjectPropertyExpression)ax.getProperty();
        if (p instanceof OWLObjectProperty) {
            this.objectPropertyPanel.setSelection((OWLObjectProperty)p);
        }
        if (!((OWLIndividual)ax.getObject()).isAnonymous()) {
            this.individualSelectorPanel.setSelection(((OWLIndividual)ax.getObject()).asOWLNamedIndividual());
        }
    }

    @Override
    public OWLObjectPropertyIndividualPair getEditedObject() {
        return new OWLObjectPropertyIndividualPair((OWLObjectPropertyExpression)this.objectPropertyPanel.getSelectedObject(), (OWLIndividual)this.individualSelectorPanel.getSelectedObject());
    }

    @Override
    public Set<OWLObjectPropertyIndividualPair> getEditedObjects() {
        HashSet<OWLObjectPropertyIndividualPair> pairs = new HashSet<OWLObjectPropertyIndividualPair>();
        for (OWLObjectProperty prop : this.objectPropertyPanel.getSelectedObjects()) {
            for (OWLNamedIndividual ind : this.individualSelectorPanel.getSelectedObjects()) {
                pairs.add(new OWLObjectPropertyIndividualPair((OWLObjectPropertyExpression)prop, (OWLIndividual)ind));
            }
        }
        return pairs;
    }

    @Override
    public boolean setEditedObject(OWLObjectPropertyIndividualPair editedObject) {
        if (editedObject == null) {
            this.objectPropertyPanel.clearSelection();
            this.individualSelectorPanel.clearSelection();
        } else if (!editedObject.getProperty().isAnonymous() && !editedObject.getIndividual().isAnonymous()) {
            this.objectPropertyPanel.setSelection(editedObject.getProperty().asOWLObjectProperty());
            this.individualSelectorPanel.setSelection(editedObject.getIndividual().asOWLNamedIndividual());
        } else {
            return false;
        }
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Object property assertion";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLObjectPropertyIndividualPair;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editorPanel;
    }

    @Override
    public void dispose() {
        this.objectPropertyPanel.dispose();
        this.individualSelectorPanel.dispose();
    }
}

