/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLObjectPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLObjectProperty;

public class OWLObjectPropertyEditor
extends AbstractOWLObjectEditor<OWLObjectProperty>
implements VerifiedInputEditor {
    private OWLObjectPropertySelectorPanel editor;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            OWLObjectPropertyEditor.this.handleVerifyEditorContents();
        }
    };

    public OWLObjectPropertyEditor(OWLEditorKit owlEditorKit) {
        this.editor = new OWLObjectPropertySelectorPanel(owlEditorKit);
        this.editor.addStatusChangedListener(this.inputListener);
    }

    @Override
    public OWLObjectProperty getEditedObject() {
        return this.editor.getSelectedObject();
    }

    @Override
    public boolean setEditedObject(OWLObjectProperty p) {
        this.editor.setSelection(p);
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Object property";
    }

    @Override
    public boolean canEdit(Object object) {
        return object instanceof OWLObjectProperty;
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editor;
    }

    private void handleVerifyEditorContents() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(true);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(true);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        this.editor.dispose();
    }
}

