/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.ui.editor.AbstractRestrictionCreatorPanel;
import org.protege.editor.owl.ui.selector.AbstractHierarchySelectorPanel;
import org.protege.editor.owl.ui.selector.AbstractSelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.protege.editor.owl.ui.selector.OWLDataTypeSelectorPanel;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLQuantifiedRestriction;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class OWLDataRestrictionCreatorPanel
extends AbstractRestrictionCreatorPanel<OWLDataProperty, OWLDatatype> {
    private AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype> some;
    private AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype> only;
    private AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLDataProperty, OWLDatatype> min;
    private AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLDataProperty, OWLDatatype> exactly;
    private AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLDataProperty, OWLDatatype> max;

    @Override
    protected List<AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype>> createTypes() {
        ArrayList<AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype>> types = new ArrayList<AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype>>();
        this.some = new AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype>("Some (existential)"){

            @Override
            public void createRestrictions(Set<OWLDataProperty> properties, Set<OWLDatatype> fillers, Set<OWLClassExpression> result) {
                for (OWLDataProperty prop : properties) {
                    for (OWLDatatype filler : fillers) {
                        result.add((OWLClassExpression)OWLDataRestrictionCreatorPanel.this.getDataFactory().getOWLDataSomeValuesFrom((OWLDataPropertyExpression)prop, (OWLDataRange)filler));
                    }
                }
            }
        };
        types.add(this.some);
        this.only = new AbstractRestrictionCreatorPanel.RestrictionCreator<OWLDataProperty, OWLDatatype>("Only (universal)"){

            @Override
            public void createRestrictions(Set<OWLDataProperty> properties, Set<OWLDatatype> fillers, Set<OWLClassExpression> result) {
                for (OWLDataProperty prop : properties) {
                    if (fillers.isEmpty()) {
                        return;
                    }
                    OWLDatatype filler = fillers.iterator().next();
                    result.add((OWLClassExpression)OWLDataRestrictionCreatorPanel.this.getDataFactory().getOWLDataAllValuesFrom((OWLDataPropertyExpression)prop, (OWLDataRange)filler));
                }
            }
        };
        types.add(this.only);
        this.min = new AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLDataProperty, OWLDatatype>("Min (min cardinality)"){

            @Override
            public OWLClassExpression createRestriction(OWLDataProperty prop, OWLDatatype filler, int card) {
                return OWLDataRestrictionCreatorPanel.this.getDataFactory().getOWLDataMinCardinality(card, (OWLDataPropertyExpression)prop, (OWLDataRange)filler);
            }
        };
        types.add(this.min);
        this.exactly = new AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLDataProperty, OWLDatatype>("Exactly (exact cardinality)"){

            @Override
            public OWLClassExpression createRestriction(OWLDataProperty prop, OWLDatatype filler, int card) {
                return OWLDataRestrictionCreatorPanel.this.getDataFactory().getOWLDataExactCardinality(card, (OWLDataPropertyExpression)prop, (OWLDataRange)filler);
            }
        };
        types.add(this.exactly);
        this.max = new AbstractRestrictionCreatorPanel.CardinalityRestrictionCreator<OWLDataProperty, OWLDatatype>("Max (max cardinality)"){

            @Override
            public OWLClassExpression createRestriction(OWLDataProperty prop, OWLDatatype filler, int card) {
                return OWLDataRestrictionCreatorPanel.this.getDataFactory().getOWLDataMaxCardinality(card, (OWLDataPropertyExpression)prop, (OWLDataRange)filler);
            }
        };
        types.add(this.max);
        return types;
    }

    @Override
    protected AbstractSelectorPanel<OWLDatatype> createFillerSelectorPanel() {
        return new OWLDataTypeSelectorPanel(this.getOWLEditorKit());
    }

    @Override
    protected AbstractHierarchySelectorPanel<OWLDataProperty> createPropertySelectorPanel() {
        return new OWLDataPropertySelectorPanel(this.getOWLEditorKit());
    }

    @Override
    public boolean setDescription(OWLClassExpression description) {
        if (description == null) {
            return true;
        }
        AcceptableExpressionFilter filter = new AcceptableExpressionFilter();
        description.accept((OWLClassExpressionVisitor)filter);
        if (filter.isAcceptable) {
            this.setProperty(filter.p);
            this.setFiller(filter.f);
            this.setType(filter.t);
            if (filter.cardinality >= 0) {
                this.setCardinality(filter.cardinality);
            }
            return true;
        }
        return false;
    }

    class AcceptableExpressionFilter
    extends OWLClassExpressionVisitorAdapter {
        private boolean isAcceptable = false;
        private OWLDataProperty p;
        private OWLDatatype f;
        private AbstractRestrictionCreatorPanel.RestrictionCreator t;
        private int cardinality = -1;

        AcceptableExpressionFilter() {
        }

        private void handleRestriction(OWLQuantifiedRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange> r) {
            if (!((OWLDataPropertyExpression)r.getProperty()).isAnonymous() && ((OWLDataRange)r.getFiller()).isDatatype()) {
                this.p = ((OWLDataPropertyExpression)r.getProperty()).asOWLDataProperty();
                this.f = ((OWLDataRange)r.getFiller()).asOWLDatatype();
                this.isAcceptable = true;
            }
        }

        public void visit(OWLDataSomeValuesFrom r) {
            this.t = OWLDataRestrictionCreatorPanel.this.some;
            this.handleRestriction((OWLQuantifiedRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)r);
        }

        public void visit(OWLDataAllValuesFrom r) {
            this.t = OWLDataRestrictionCreatorPanel.this.only;
            this.handleRestriction((OWLQuantifiedRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)r);
        }

        public void visit(OWLDataMinCardinality r) {
            this.t = OWLDataRestrictionCreatorPanel.this.min;
            this.cardinality = r.getCardinality();
            this.handleRestriction((OWLQuantifiedRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)r);
        }

        public void visit(OWLDataExactCardinality r) {
            this.t = OWLDataRestrictionCreatorPanel.this.exactly;
            this.cardinality = r.getCardinality();
            this.handleRestriction((OWLQuantifiedRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)r);
        }

        public void visit(OWLDataMaxCardinality r) {
            this.t = OWLDataRestrictionCreatorPanel.this.max;
            this.cardinality = r.getCardinality();
            this.handleRestriction((OWLQuantifiedRestriction<OWLDataRange, OWLDataPropertyExpression, OWLDataRange>)r);
        }
    }
}

