/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.AbstractOWLObjectEditor;
import org.protege.editor.owl.ui.selector.OWLDataPropertySelectorPanel;
import org.semanticweb.owlapi.model.OWLDataProperty;

public class OWLDataPropertySetEditor
extends AbstractOWLObjectEditor<Set<OWLDataProperty>>
implements VerifiedInputEditor {
    private OWLDataPropertySelectorPanel editor;
    private Set<InputVerificationStatusChangedListener> listeners = new HashSet<InputVerificationStatusChangedListener>();
    private InputVerificationStatusChangedListener inputListener = new InputVerificationStatusChangedListener(){

        public void verifiedStatusChanged(boolean newState) {
            OWLDataPropertySetEditor.this.handleVerifyEditorContents();
        }
    };

    public OWLDataPropertySetEditor(OWLEditorKit owlEditorKit) {
        this.editor = new OWLDataPropertySelectorPanel(owlEditorKit);
        this.editor.addStatusChangedListener(this.inputListener);
    }

    @Override
    public Set<OWLDataProperty> getEditedObject() {
        return this.editor.getSelectedObjects();
    }

    @Override
    public boolean setEditedObject(Set<OWLDataProperty> p) {
        this.editor.setSelection(p != null ? p : Collections.EMPTY_SET);
        return true;
    }

    @Override
    public String getEditorTypeName() {
        return "Set of Data Properties";
    }

    @Override
    public boolean canEdit(Object object) {
        return this.checkSet(object, OWLDataProperty.class);
    }

    @Override
    public JComponent getEditorComponent() {
        return this.editor;
    }

    private void handleVerifyEditorContents() {
        for (InputVerificationStatusChangedListener l : this.listeners) {
            l.verifiedStatusChanged(true);
        }
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.add(l);
        l.verifiedStatusChanged(true);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener l) {
        this.listeners.remove(l);
    }

    @Override
    public void dispose() {
        this.editor.dispose();
    }
}

