/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class RemoveAllDisjointAxiomsAction
extends ProtegeOWLAction {
    private static final Logger logger = Logger.getLogger(RemoveAllDisjointAxiomsAction.class);
    private OWLModelManagerListener listener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED)) {
                RemoveAllDisjointAxiomsAction.this.updateState();
            }
        }
    };

    public void actionPerformed(ActionEvent e) {
        try {
            UIHelper uiHelper = new UIHelper(this.getOWLEditorKit());
            int result = uiHelper.showOptionPane("Include imported ontologies?", "Do you want to remove the disjoint axioms from \nimported ontologies?", 1, 3);
            Set<Object> ontologies = new HashSet<OWLOntology>();
            if (result == 0) {
                ontologies.addAll(this.getOWLModelManager().getActiveOntologies());
            } else if (result == 1) {
                ontologies = Collections.singleton(this.getOWLModelManager().getActiveOntology());
            }
            ArrayList<RemoveAxiom> changes = new ArrayList<RemoveAxiom>();
            for (OWLOntology oWLOntology : ontologies) {
                for (OWLDisjointClassesAxiom ax : oWLOntology.getAxioms(AxiomType.DISJOINT_CLASSES)) {
                    changes.add(new RemoveAxiom(oWLOntology, (OWLAxiom)ax));
                }
            }
            this.getOWLModelManager().applyChanges(changes);
        }
        catch (Exception e1) {
            logger.error((Object)e1);
        }
    }

    private void updateState() {
        this.setEnabled(this.getOWLModelManager().isActiveOntologyMutable());
    }

    public void initialise() throws Exception {
        this.getOWLModelManager().addListener(this.listener);
        this.updateState();
    }

    public void dispose() {
        this.getOWLModelManager().removeListener(this.listener);
    }
}

