/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.protege.editor.owl.ui.action.FocusedComponentAction;
import org.protege.editor.owl.ui.transfer.OWLObjectDataFlavor;
import org.protege.editor.owl.ui.view.Pasteable;
import org.protege.editor.owl.ui.view.ViewClipboard;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLRuntimeException;

public class PasteAction
extends FocusedComponentAction<Pasteable> {
    @Override
    protected boolean canPerform() {
        return ((Pasteable)this.getCurrentTarget()).canPaste(PasteAction.getObjectsOnClipboard());
    }

    @Override
    protected Class<Pasteable> initialiseAction() {
        return Pasteable.class;
    }

    public void actionPerformed(ActionEvent e) {
        List<OWLObject> objects = PasteAction.getObjectsOnClipboard();
        if (!objects.isEmpty()) {
            ((Pasteable)this.getCurrentTarget()).pasteObjects(objects);
        }
    }

    private static List<OWLObject> getObjectsOnClipboard() {
        try {
            Transferable transferable = ViewClipboard.getInstance().getClipboard().getContents(null);
            if (transferable == null) {
                return Collections.emptyList();
            }
            if (transferable.isDataFlavorSupported(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR)) {
                return (List)transferable.getTransferData(OWLObjectDataFlavor.OWL_OBJECT_DATA_FLAVOR);
            }
        }
        catch (UnsupportedFlavorException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        return Collections.emptyList();
    }
}

