/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.Dimension;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import org.protege.editor.core.prefs.Preferences;
import org.protege.editor.core.prefs.PreferencesManager;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.util.OWLEntityRemover;
import org.semanticweb.owlapi.util.OWLEntitySetProvider;

public class OWLObjectHierarchyDeleter<E extends OWLEntity> {
    private OWLEditorKit owlEditorKit;
    private OWLEntitySetProvider<E> entitySetProvider;
    private OWLObjectHierarchyProvider<E> hierarchyProvider;
    private String pluralName;
    private static final String DELETE_PREFS_KEY = "delete.preferences";
    private static final String ALWAYS_DELETE_CONFIRM = "delete.confirm.always";
    private static final String ALWAYS_CONFIRM_WHEN_DELETE_DESCENDANTS = "delete.confirm.descendants";
    private static final String DELETE_DESCENDANTS = "delete.descendants";

    public OWLObjectHierarchyDeleter(OWLEditorKit owlEditorKit, OWLObjectHierarchyProvider<E> hierarchyProvider, OWLEntitySetProvider<E> entitySetProvider, String pluralName) {
        this.owlEditorKit = owlEditorKit;
        this.hierarchyProvider = hierarchyProvider;
        this.entitySetProvider = entitySetProvider;
        this.pluralName = pluralName;
    }

    public void dispose() {
    }

    public OWLEditorKit getOWLEditorKit() {
        return this.owlEditorKit;
    }

    public void performDeletion() {
        Preferences prefs = PreferencesManager.getInstance().getApplicationPreferences(DELETE_PREFS_KEY);
        Set selents = this.entitySetProvider.getEntities();
        String name = selents.size() == 1 ? this.owlEditorKit.getModelManager().getRendering((OWLObject)selents.iterator().next()) : "selected " + this.pluralName;
        boolean assertedSubsExist = this.hasAssertedSubs(selents);
        boolean showDialog = prefs.getBoolean(ALWAYS_DELETE_CONFIRM, true);
        if (assertedSubsExist) {
            showDialog = prefs.getBoolean(ALWAYS_CONFIRM_WHEN_DELETE_DESCENDANTS, true);
        }
        boolean deleteDescendants = false;
        if (showDialog) {
            Box panel = new Box(3);
            JLabel label = new JLabel("<html><body>Delete " + name + "?<p>All references to " + name + " will be removed from the active ontologies.</p></body></html>");
            panel.add(label);
            String confirmLabel = "Always show this confirmation before deleting";
            JRadioButton descendantsRadioButton = null;
            if (assertedSubsExist) {
                deleteDescendants = prefs.getBoolean(DELETE_DESCENDANTS, false);
                JRadioButton onlySelectedEntityRadioButton = new JRadioButton("Delete " + name + " only", !deleteDescendants);
                descendantsRadioButton = new JRadioButton("Delete " + name + " and asserted descendant " + this.pluralName, deleteDescendants);
                ButtonGroup bg = new ButtonGroup();
                bg.add(onlySelectedEntityRadioButton);
                bg.add(descendantsRadioButton);
                panel.add(Box.createRigidArea(new Dimension(0, 20)));
                panel.add(onlySelectedEntityRadioButton);
                panel.add(descendantsRadioButton);
                confirmLabel = confirmLabel + " " + this.pluralName + " with asserted descendants";
            }
            JCheckBox alwaysConfirmCheckbox = new JCheckBox(confirmLabel, true);
            panel.add(Box.createRigidArea(new Dimension(0, 40)));
            panel.add(alwaysConfirmCheckbox);
            int ret = JOptionPane.showConfirmDialog((Component)((Object)this.owlEditorKit.getWorkspace()), panel, "Delete " + name, 2, -1);
            if (ret != 0) {
                return;
            }
            if (assertedSubsExist) {
                deleteDescendants = descendantsRadioButton.isSelected();
                prefs.putBoolean(DELETE_DESCENDANTS, deleteDescendants);
                prefs.putBoolean(ALWAYS_CONFIRM_WHEN_DELETE_DESCENDANTS, alwaysConfirmCheckbox.isSelected());
            }
            prefs.putBoolean(ALWAYS_DELETE_CONFIRM, alwaysConfirmCheckbox.isSelected());
        }
        if (deleteDescendants) {
            this.deleteDescendants(selents);
        } else {
            this.delete(selents);
        }
    }

    private boolean hasAssertedSubs(Set<E> entities) {
        for (OWLEntity entity : entities) {
            if (this.hierarchyProvider.getDescendants(entity).isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void delete(Set<E> ents) {
        OWLEntityRemover remover = new OWLEntityRemover(this.owlEditorKit.getModelManager().getOWLOntologyManager(), this.owlEditorKit.getModelManager().getOntologies());
        for (OWLEntity ent : ents) {
            ent.accept((OWLEntityVisitor)remover);
        }
        this.owlEditorKit.getModelManager().applyChanges(remover.getChanges());
    }

    private void deleteDescendants(Set<E> selents) {
        HashSet<OWLEntity> ents = new HashSet<OWLEntity>();
        for (OWLEntity ent : selents) {
            ents.add(ent);
            ents.addAll(this.hierarchyProvider.getDescendants(ent));
        }
        this.delete(ents);
    }
}

