/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.JOptionPane;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.ui.GatherOntologiesPanel;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;

public class GatherOntologiesAction
extends ProtegeOWLAction {
    public void actionPerformed(ActionEvent e) {
        GatherOntologiesPanel panel = GatherOntologiesPanel.showDialog(this.getOWLEditorKit());
        if (panel == null) {
            return;
        }
        boolean errors = false;
        OWLOntologyFormat saveAsFormat = panel.getOntologyFormat();
        File saveAsLocation = panel.getSaveLocation();
        for (OWLOntology ont : panel.getOntologiesToSave()) {
            URI originalPhysicalURI;
            String originalPath;
            OWLOntologyFormat format = saveAsFormat;
            OWLOntologyManager man = this.getOWLModelManager().getOWLOntologyManager();
            if (format == null) {
                format = man.getOntologyFormat(ont);
            }
            if ((originalPath = (originalPhysicalURI = man.getOntologyDocumentIRI(ont).toURI()).getPath()) == null) {
                originalPath = System.currentTimeMillis() + ".owl";
            }
            File originalFile = new File(originalPath);
            String originalFileName = originalFile.getName();
            File saveAsFile = new File(saveAsLocation, originalFileName);
            try {
                man.saveOntology(ont, format, IRI.create((File)saveAsFile));
            }
            catch (OWLOntologyStorageException e1) {
                ProtegeApplication.getErrorLog().handleError(Thread.currentThread(), (Throwable)e1);
                errors = true;
            }
        }
        if (errors) {
            JOptionPane.showMessageDialog((Component)this.getWorkspace(), "There were errors when saving the ontologies.  Please check the log for details.", "Error during save", 0);
        }
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }
}

