/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.RemoveAxiom;
import org.semanticweb.owlapi.util.OWLObjectDuplicator;

public class ConvertMinOneToSomeValuesFromAction
extends ProtegeOWLAction {
    Logger logger = Logger.getLogger(ConvertMinOneToSomeValuesFromAction.class);

    public void actionPerformed(ActionEvent actionEvent) {
        MinCardiOneReplacer replacer = new MinCardiOneReplacer(this.getOWLModelManager().getOWLDataFactory());
        ArrayList<Object> changes = new ArrayList<Object>();
        int count = 0;
        for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
            for (OWLAxiom ax : ont.getAxioms()) {
                OWLAxiom ax2;
                if (!ax.isLogicalAxiom() || ax.equals(ax2 = (OWLAxiom)replacer.duplicateObject((OWLObject)ax))) continue;
                changes.add(new RemoveAxiom(ont, ax));
                changes.add(new AddAxiom(ont, ax2));
                ++count;
            }
        }
        this.getOWLModelManager().applyChanges(changes);
        this.logger.info((Object)("Converted " + count + " qualified min 1 restrictions to someValuesFrom restrictions"));
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }

    class MinCardiOneReplacer
    extends OWLObjectDuplicator {
        public MinCardiOneReplacer(OWLDataFactory owlDataFactory) {
            super(owlDataFactory);
        }

        public void visit(OWLObjectMinCardinality min) {
            if (min.getCardinality() == 1 && min.isQualified()) {
                OWLObjectSomeValuesFrom someValuesFrom = ConvertMinOneToSomeValuesFromAction.this.getOWLDataFactory().getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)min.getProperty(), (OWLClassExpression)min.getFiller());
                this.visit(someValuesFrom);
            } else {
                super.visit(min);
            }
        }

        public void visit(OWLDataMinCardinality min) {
            if (min.getCardinality() == 1 && min.isQualified()) {
                OWLDataSomeValuesFrom someValuesFrom = ConvertMinOneToSomeValuesFromAction.this.getOWLDataFactory().getOWLDataSomeValuesFrom((OWLDataPropertyExpression)min.getProperty(), (OWLDataRange)min.getFiller());
                this.visit(someValuesFrom);
            } else {
                super.visit(min);
            }
        }
    }
}

