/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import org.protege.editor.owl.ui.action.ProtegeOWLAction;
import org.protege.editor.owl.ui.ontology.OntologyIDJDialog;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveImport;
import org.semanticweb.owlapi.model.SetOntologyID;

public class ChangeOntologyIRI
extends ProtegeOWLAction {
    private static final long serialVersionUID = -6080240335045735182L;

    public void actionPerformed(ActionEvent e) {
        OWLOntology ont = this.getOWLModelManager().getActiveOntology();
        OWLOntologyID id = OntologyIDJDialog.showDialog(this.getOWLEditorKit(), ont.getOntologyID());
        if (id != null) {
            this.getOWLModelManager().applyChanges(this.getChanges(ont, id));
        }
    }

    private List<OWLOntologyChange> getChanges(OWLOntology ontology, OWLOntologyID id) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        OWLOntologyManager owlOntologyManager = ontology.getOWLOntologyManager();
        OWLDataFactory factory = owlOntologyManager.getOWLDataFactory();
        OWLOntologyID oldId = ontology.getOntologyID();
        changes.add((OWLOntologyChange)new SetOntologyID(ontology, id));
        if (!id.isAnonymous() && !id.equals((Object)oldId)) {
            for (OWLOntology ont : owlOntologyManager.getOntologies()) {
                for (OWLImportsDeclaration decl : ont.getImportsDeclarations()) {
                    if (decl.getIRI().equals(oldId.getVersionIRI())) {
                        changes.add((OWLOntologyChange)new RemoveImport(ont, decl));
                        changes.add((OWLOntologyChange)new AddImport(ont, factory.getOWLImportsDeclaration(id.getDefaultDocumentIRI())));
                        continue;
                    }
                    if (!decl.getIRI().equals(oldId.getOntologyIRI())) continue;
                    changes.add((OWLOntologyChange)new RemoveImport(ont, decl));
                    changes.add((OWLOntologyChange)new AddImport(ont, factory.getOWLImportsDeclaration(id.getOntologyIRI())));
                }
            }
        }
        return changes;
    }

    public void initialise() throws Exception {
    }

    public void dispose() throws Exception {
    }
}

