/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import de.uulm.ecs.ai.owlapi.krssparser.KRSS2OntologyFormat;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.coode.owlapi.latex.LatexOntologyFormat;
import org.coode.owlapi.manchesterowlsyntax.ManchesterOWLSyntaxOntologyFormat;
import org.coode.owlapi.obo.parser.OBOOntologyFormat;
import org.coode.owlapi.turtle.TurtleOntologyFormat;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.owl.OWLEditorKit;
import org.semanticweb.owlapi.io.OWLFunctionalSyntaxOntologyFormat;
import org.semanticweb.owlapi.io.OWLXMLOntologyFormat;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyFormat;

public class OntologyFormatPanel
extends JPanel {
    private static final long serialVersionUID = 1207904671457290130L;
    private JComboBox formatComboBox;
    private JLabel messageLabel;

    public OntologyFormatPanel() {
        ArrayList<Object> formats = new ArrayList<Object>();
        formats.add(new RDFXMLOntologyFormat());
        formats.add(new OWLXMLOntologyFormat());
        formats.add(new OWLFunctionalSyntaxOntologyFormat());
        formats.add(new ManchesterOWLSyntaxOntologyFormat());
        formats.add(new OBOOntologyFormat());
        formats.add(new KRSS2OntologyFormat());
        formats.add(new LatexOntologyFormat());
        formats.add(new TurtleOntologyFormat());
        this.formatComboBox = new JComboBox<Object>(formats.toArray());
        this.setLayout(new BorderLayout(12, 12));
        this.add((Component)this.formatComboBox, "South");
        this.formatComboBox.setSelectedItem(formats.get(0));
    }

    public void setSelectedFormat(OWLOntologyFormat format) {
        if (format == null) {
            this.formatComboBox.setSelectedIndex(0);
        }
        for (int i = 0; i < this.formatComboBox.getModel().getSize(); ++i) {
            if (!this.formatComboBox.getModel().getElementAt(i).equals(format)) continue;
            this.formatComboBox.setSelectedIndex(i);
            return;
        }
    }

    public void setMessage(String message) {
        if (this.messageLabel == null) {
            this.messageLabel = new JLabel(message);
            this.add((Component)this.messageLabel, "North");
        } else {
            this.messageLabel.setText(message);
        }
        this.revalidate();
    }

    public OWLOntologyFormat getSelectedFormat() {
        return (OWLOntologyFormat)this.formatComboBox.getSelectedItem();
    }

    public void addItemListener(ItemListener l) {
        this.formatComboBox.addItemListener(l);
    }

    public void removeItemListener(ItemListener l) {
        this.formatComboBox.removeItemListener(l);
    }

    @Deprecated
    public static OWLOntologyFormat showDialog(OWLEditorKit editorKit, OWLOntologyFormat defaultFormat) {
        return OntologyFormatPanel.showDialog(editorKit, defaultFormat, null);
    }

    public static OWLOntologyFormat showDialog(OWLEditorKit editorKit, OWLOntologyFormat defaultFormat, String message) {
        OntologyFormatPanel panel = new OntologyFormatPanel();
        if (message != null) {
            panel.setMessage(message);
        }
        panel.setSelectedFormat(defaultFormat);
        OWLOntologyFormat selectedFormat = null;
        do {
            int ret;
            if ((ret = JOptionPaneEx.showConfirmDialog((Component)((Object)editorKit.getWorkspace()), (String)"Select an ontology format", (JComponent)panel, (int)-1, (int)2, (JComponent)panel.formatComboBox)) == 0) continue;
            return null;
        } while (!OntologyFormatPanel.isFormatOk(editorKit, selectedFormat = panel.getSelectedFormat()));
        return selectedFormat;
    }

    private static boolean isFormatOk(OWLEditorKit editorKit, OWLOntologyFormat format) {
        if (!(format instanceof ManchesterOWLSyntaxOntologyFormat)) {
            return true;
        }
        int userSaysOk = JOptionPane.showConfirmDialog((Component)((Object)editorKit.getOWLWorkspace()), "The Manchester OWL Syntax can lose information such as GCI's and annotations of undeclared entities.  Continue?", "Warning", 0);
        return userSaysOk == 0;
    }
}

