/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import org.protege.editor.core.ui.util.InputVerificationStatusChangedListener;
import org.protege.editor.core.ui.util.JOptionPaneEx;
import org.protege.editor.core.ui.util.VerifiedInputEditor;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.ui.OWLEntityCreationPanel;
import org.semanticweb.owlapi.model.AddAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLOntologyChange;

public class CreateDefinedClassPanel
extends JPanel
implements VerifiedInputEditor {
    private static final long serialVersionUID = -6715907571161404126L;
    private OWLEntityCreationPanel<OWLClass> entityCreatePanel;
    private JRadioButton anonymousButton;
    private JRadioButton namedButton;
    private List<InputVerificationStatusChangedListener> listeners = new ArrayList<InputVerificationStatusChangedListener>();
    private ActionListener buttonListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            if (CreateDefinedClassPanel.this.namedButton.isSelected()) {
                CreateDefinedClassPanel.this.entityCreatePanel.setEnabled(true);
                for (InputVerificationStatusChangedListener l : CreateDefinedClassPanel.this.listeners) {
                    CreateDefinedClassPanel.this.entityCreatePanel.addStatusChangedListener(l);
                }
            } else {
                CreateDefinedClassPanel.this.entityCreatePanel.setEnabled(false);
                for (InputVerificationStatusChangedListener l : CreateDefinedClassPanel.this.listeners) {
                    CreateDefinedClassPanel.this.entityCreatePanel.removeStatusChangedListener(l);
                    l.verifiedStatusChanged(true);
                }
            }
        }
    };

    public CreateDefinedClassPanel(OWLEditorKit eKit) {
        this.setLayout(new BorderLayout());
        this.anonymousButton = new JRadioButton("Anonymous class", true);
        this.anonymousButton.setAlignmentX(0.0f);
        this.namedButton = new JRadioButton("Named class", !this.anonymousButton.isSelected());
        this.namedButton.setAlignmentY(0.0f);
        this.anonymousButton.addActionListener(this.buttonListener);
        this.namedButton.addActionListener(this.buttonListener);
        this.entityCreatePanel = new OWLEntityCreationPanel<OWLClass>(eKit, null, OWLClass.class);
        this.entityCreatePanel.setEnabled(this.namedButton.isSelected());
        this.entityCreatePanel.setAlignmentY(0.0f);
        this.entityCreatePanel.setBorder(new EmptyBorder(0, 20, 0, 0));
        Box namedPanel = new Box(2);
        namedPanel.setAlignmentX(0.0f);
        namedPanel.add(this.namedButton);
        namedPanel.add(this.entityCreatePanel);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.namedButton);
        bg.add(this.anonymousButton);
        Box box = new Box(3);
        box.add(this.anonymousButton);
        box.add(namedPanel);
        this.add((Component)box, "Center");
    }

    private JComponent getDefaultFocusedComponent() {
        return this.anonymousButton;
    }

    public OWLEntityCreationSet<OWLClass> getEntityCreationSet() {
        if (this.anonymousButton.isSelected()) {
            return null;
        }
        return this.entityCreatePanel.getOWLEntityCreationSet();
    }

    public void addStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeStatusChangedListener(InputVerificationStatusChangedListener listener) {
        this.listeners.remove(listener);
    }

    public static OWLEntityCreationSet<OWLClass> showDialog(OWLClassExpression desc, OWLEditorKit eKit) {
        OWLEntityCreationSet<OWLClass> creationSet = null;
        AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)eKit.getOWLModelManager().get(AnonymousDefinedClassManager.ID);
        if (adcManager != null) {
            CreateDefinedClassPanel panel = new CreateDefinedClassPanel(eKit);
            int ret = JOptionPaneEx.showValidatingConfirmDialog((Component)eKit.getOWLWorkspace().getRootPane(), (String)"Create defined class", (JComponent)panel, (int)-1, (int)2, (JComponent)panel.getDefaultFocusedComponent());
            if (ret == 0) {
                creationSet = panel.getEntityCreationSet();
                creationSet = creationSet == null ? adcManager.createAnonymousClass(eKit.getOWLModelManager().getActiveOntology(), desc) : CreateDefinedClassPanel.appendDefinitionToCreationSet(creationSet, desc, eKit);
            }
        } else {
            creationSet = OWLEntityCreationPanel.showDialog(eKit, "Create defined class", OWLClass.class);
            if (creationSet != null) {
                CreateDefinedClassPanel.appendDefinitionToCreationSet(creationSet, desc, eKit);
            }
        }
        return creationSet;
    }

    private static OWLEntityCreationSet<OWLClass> appendDefinitionToCreationSet(OWLEntityCreationSet<OWLClass> creationSet, OWLClassExpression desc, OWLEditorKit eKit) {
        OWLClass owlEntity = creationSet.getOWLEntity();
        OWLEquivalentClassesAxiom ax = eKit.getOWLModelManager().getOWLDataFactory().getOWLEquivalentClassesAxiom((OWLClassExpression)owlEntity, desc);
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>(creationSet.getOntologyChanges());
        changes.add((OWLOntologyChange)new AddAxiom(eKit.getOWLModelManager().getActiveOntology(), (OWLAxiom)ax));
        return new OWLEntityCreationSet<OWLClass>(owlEntity, changes);
    }
}

