/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.util.NestedIntersectionFlattener;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.util.OWLClassExpressionVisitorAdapter;

public class ObjectSomeValuesFromFillerExtractor
extends OWLClassExpressionVisitorAdapter {
    private OWLDataFactory dataFactory;
    private OWLObjectProperty objectProperty;
    protected Set<OWLClassExpression> fillers;

    public ObjectSomeValuesFromFillerExtractor(OWLDataFactory dataFactory, OWLObjectProperty objectProperty) {
        this.dataFactory = dataFactory;
        this.objectProperty = objectProperty;
        this.fillers = new HashSet<OWLClassExpression>();
    }

    public OWLObjectProperty getObjectProperty() {
        return this.objectProperty;
    }

    public void reset() {
        this.fillers.clear();
    }

    public Set<OWLClassExpression> getFillers() {
        return new HashSet<OWLClassExpression>(this.fillers);
    }

    public void visit(OWLObjectSomeValuesFrom node) {
        if (((OWLObjectPropertyExpression)node.getProperty()).equals(this.objectProperty)) {
            NestedIntersectionFlattener flattener = new NestedIntersectionFlattener();
            ((OWLClassExpression)node.getFiller()).accept((OWLClassExpressionVisitor)flattener);
            this.fillers.addAll(flattener.getClassExpressions());
        }
    }

    public void visit(OWLObjectHasValue node) {
        if (((OWLObjectPropertyExpression)node.getProperty()).equals(this.objectProperty)) {
            this.fillers.add((OWLClassExpression)this.dataFactory.getOWLObjectOneOf(Collections.singleton(node.getValue())));
        }
    }
}

