/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.util;

import java.util.Set;
import org.protege.editor.owl.model.util.ObjectSomeValuesFromFillerExtractor;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectCardinalityRestriction;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLOntology;

public class ClosureAxiomFactory
extends ObjectSomeValuesFromFillerExtractor {
    protected OWLDataFactory owlDataFactory;
    private Set<OWLOntology> onts;

    public ClosureAxiomFactory(OWLObjectProperty objectProperty, OWLDataFactory df, Set<OWLOntology> onts) {
        super(df, objectProperty);
        this.owlDataFactory = df;
        this.onts = onts;
    }

    public static OWLAxiom getClosureAxiom(OWLClass cls, OWLObjectProperty prop, OWLDataFactory df, Set<OWLOntology> onts) {
        ClosureAxiomFactory fac = new ClosureAxiomFactory(prop, df, onts);
        cls.accept((OWLClassExpressionVisitor)fac);
        OWLObjectAllValuesFrom closure = fac.getClosureRestriction();
        return closure != null ? df.getOWLSubClassOfAxiom((OWLClassExpression)cls, (OWLClassExpression)closure) : null;
    }

    public OWLObjectAllValuesFrom getClosureRestriction() {
        Set<OWLClassExpression> descriptions = this.getFillers();
        if (descriptions.isEmpty()) {
            return null;
        }
        if (descriptions.size() == 1) {
            return this.owlDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.getObjectProperty(), descriptions.iterator().next());
        }
        return this.owlDataFactory.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)this.getObjectProperty(), (OWLClassExpression)this.owlDataFactory.getOWLObjectUnionOf(descriptions));
    }

    public void visit(OWLClass cls) {
        if (this.onts != null) {
            for (OWLClassExpression superCls : cls.getSuperClasses(this.onts)) {
                superCls.accept((OWLClassExpressionVisitor)this);
            }
            for (OWLClassExpression equiv : cls.getEquivalentClasses(this.onts)) {
                equiv.accept((OWLClassExpressionVisitor)this);
            }
        }
    }

    public void visit(OWLObjectIntersectionOf owlObjectIntersectionOf) {
        for (OWLClassExpression op : owlObjectIntersectionOf.getOperands()) {
            op.accept((OWLClassExpressionVisitor)this);
        }
    }

    public void visit(OWLObjectMinCardinality restr) {
        this.handleCardinality((OWLObjectCardinalityRestriction)restr);
    }

    public void visit(OWLObjectExactCardinality restr) {
        this.handleCardinality((OWLObjectCardinalityRestriction)restr);
    }

    @Override
    public void visit(OWLObjectSomeValuesFrom restr) {
        OWLClassExpression filler;
        if (((OWLObjectPropertyExpression)restr.getProperty()).equals(this.getObjectProperty()) && !(filler = (OWLClassExpression)restr.getFiller()).equals(this.owlDataFactory.getOWLThing())) {
            this.fillers.add(filler);
        }
    }

    private void handleCardinality(OWLObjectCardinalityRestriction restr) {
        OWLClassExpression filler;
        if (((OWLObjectPropertyExpression)restr.getProperty()).equals(this.getObjectProperty()) && restr.getCardinality() > 0 && !(filler = (OWLClassExpression)restr.getFiller()).equals(this.owlDataFactory.getOWLThing())) {
            this.fillers.add(filler);
        }
    }
}

