/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.selection;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.protege.editor.owl.model.selection.OWLSelectionHistoryManager;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelListener;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;

public class OWLSelectionHistoryManagerImpl
implements OWLSelectionHistoryManager {
    private OWLSelectionModel selectionModel;
    private OWLSelectionModelListener listener;
    private List<ChangeListener> changeListeners;
    private boolean initiatedSelection;
    private Stack<OWLEntity> prevSelections;
    private Stack<OWLEntity> forwardSelections;
    private OWLEntity curSel;

    public OWLSelectionHistoryManagerImpl(OWLSelectionModel owlSelectionModel) {
        this.selectionModel = owlSelectionModel;
        this.changeListeners = new ArrayList<ChangeListener>();
        this.prevSelections = new Stack();
        this.forwardSelections = new Stack();
        this.listener = new OWLSelectionModelListener(){

            @Override
            public void selectionChanged() throws Exception {
                OWLSelectionHistoryManagerImpl.this.handleSelection();
            }
        };
        this.selectionModel.addListener(this.listener);
    }

    private void handleSelection() {
        OWLObject obj = this.selectionModel.getSelectedObject();
        if (obj instanceof OWLEntity) {
            if (!this.initiatedSelection) {
                if (this.curSel != null) {
                    this.prevSelections.push(this.curSel);
                }
                this.forwardSelections.clear();
            }
            this.curSel = (OWLEntity)obj;
            this.fireStateChanged();
        }
    }

    @Override
    public void dispose() {
        if (this.listener != null) {
            this.selectionModel.removeListener(this.listener);
        }
    }

    @Override
    public boolean canGoBack() {
        return !this.prevSelections.isEmpty();
    }

    @Override
    public void goBack() {
        if (!this.canGoBack()) {
            return;
        }
        this.initiatedSelection = true;
        OWLEntity entity = this.prevSelections.pop();
        this.forwardSelections.push(this.curSel);
        this.selectionModel.setSelectedEntity(entity);
        this.initiatedSelection = false;
    }

    @Override
    public boolean canGoForward() {
        return !this.forwardSelections.isEmpty();
    }

    @Override
    public void goForward() {
        if (!this.canGoForward()) {
            return;
        }
        this.initiatedSelection = true;
        OWLEntity entity = this.forwardSelections.pop();
        this.prevSelections.push(this.curSel);
        this.selectionModel.setSelectedEntity(entity);
        this.initiatedSelection = false;
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.remove(changeListener);
    }

    protected void fireStateChanged() {
        for (ChangeListener listener : new ArrayList<ChangeListener>(this.changeListeners)) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }
}

