/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.repository.extractors;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.repository.extractors.OntologyIdExtractor;
import org.protege.editor.owl.model.repository.extractors.RdfExtractorConsumer;
import org.protege.owlapi.util.IOUtils;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.rdf.syntax.RDFConsumer;
import org.semanticweb.owlapi.rdf.syntax.RDFParser;
import org.xml.sax.InputSource;

public class RdfXmlExtractor
implements OntologyIdExtractor {
    private Logger log = Logger.getLogger(RdfXmlExtractor.class);
    private URI location;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWLOntologyID getOntologyId() {
        RdfExtractorConsumer consumer = new RdfExtractorConsumer();
        RDFParser parser = new RDFParser();
        InputStream iStream = null;
        try {
            iStream = IOUtils.getInputStream((URI)this.location);
            InputSource is = new InputSource(iStream);
            is.setSystemId(this.location.toURL().toString());
            parser.parse(is, (RDFConsumer)consumer);
        }
        catch (Throwable t) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Exception caught trying to extract ontology from rdf file at  " + this.location), t);
            }
            OWLOntologyID oWLOntologyID = null;
            return oWLOntologyID;
        }
        finally {
            if (iStream != null) {
                try {
                    iStream.close();
                }
                catch (IOException ioe) {
                    this.log.warn((Object)"Could not close open stream", (Throwable)ioe);
                }
            }
        }
        return consumer.getOntologyID();
    }

    @Override
    public void setPhysicalAddress(URI location) {
        this.location = location;
    }
}

