/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.refactor;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.util.OWLEntityRenamer;

public class EntityFindAndReplaceURIRenamer {
    private Logger logger = Logger.getLogger(EntityFindAndReplaceURIRenamer.class);
    private OWLOntologyManager mngr;
    private Collection<OWLEntity> entities;
    private Set<OWLOntology> ontologies;
    private String pattern;
    private String newText;
    private Map<OWLEntity, IRI> entity2IRIMap = new HashMap<OWLEntity, IRI>();
    private Map<OWLEntity, String> errorMap = new HashMap<OWLEntity, String>();

    public EntityFindAndReplaceURIRenamer(OWLOntologyManager mngr, Collection<OWLEntity> entities, Set<OWLOntology> ontologies, String pattern, String newText) {
        this.mngr = mngr;
        this.entities = entities;
        this.ontologies = ontologies;
        this.pattern = pattern;
        this.newText = newText;
        this.generateNameMap();
    }

    private void generateNameMap() {
        for (OWLEntity entity : this.entities) {
            String newURIStr = entity.getIRI().toString().replaceAll("(?i)" + this.pattern, this.newText);
            try {
                URI newURI = new URI(newURIStr);
                if (!newURI.isAbsolute()) {
                    throw new URISyntaxException(newURIStr, "IRI must be absolute");
                }
                this.entity2IRIMap.put(entity, IRI.create((URI)newURI));
            }
            catch (URISyntaxException e) {
                this.errorMap.put(entity, newURIStr);
            }
        }
    }

    public boolean hasErrors() {
        return !this.errorMap.isEmpty();
    }

    public Map<OWLEntity, String> getErrors() {
        return Collections.unmodifiableMap(this.errorMap);
    }

    public List<OWLOntologyChange> getChanges() {
        OWLEntityRenamer renamer = new OWLEntityRenamer(this.mngr, this.ontologies);
        return renamer.changeIRI(this.entity2IRIMap);
    }
}

