/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.namespace;

import java.net.URI;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import org.protege.editor.owl.model.namespace.AbstractNamespaceManager;

public class NamespaceManagerImpl
extends AbstractNamespaceManager {
    Map<String, String> ns2Prefix = new TreeMap<String, String>();

    @Override
    public Map<String, String> getNamespaceMap() {
        return new TreeMap<String, String>(new NamespaceComparator());
    }

    @Override
    public boolean containsNamespace(String namespace) {
        return this.ns2Prefix.keySet().contains(namespace);
    }

    @Override
    public void addMapping(String prefix, String namespace) {
        String old = this.ns2Prefix.put(namespace, prefix);
        this.fireMappingAdded(prefix, namespace);
    }

    @Override
    public void removeMapping(String prefix, String namespace) {
        if (this.ns2Prefix.remove(namespace) != null) {
            this.fireMappingRemoved(prefix, namespace);
        }
    }

    @Override
    public String getNamespace(URI uri) {
        String uriString = uri.toString();
        for (String ns : this.ns2Prefix.keySet()) {
            if (!uriString.startsWith(ns)) continue;
            return ns;
        }
        return null;
    }

    @Override
    public String getPrefix(URI uri) {
        String ns = this.getNamespace(uri);
        if (ns == null) {
            return null;
        }
        return this.ns2Prefix.get(ns);
    }

    @Override
    public String getQName(URI uri) {
        String ns = this.getNamespace(uri);
        if (ns == null) {
            return null;
        }
        String prefix = this.getPrefix(uri);
        String uriString = uri.toString();
        String localName = uriString.substring(ns.length(), uriString.length());
        StringBuffer b = new StringBuffer(prefix.length() + localName.length() + 1);
        b.append(prefix);
        b.append(':');
        b.append(localName);
        return b.toString();
    }

    public String getLocalName(URI uri) {
        String uriString = uri.toString();
        String ns = this.getNamespace(uri);
        if (ns == null) {
            return null;
        }
        return uriString.substring(ns.length(), uriString.length());
    }

    private class NamespaceComparator
    implements Comparator<String> {
        private NamespaceComparator() {
        }

        @Override
        public int compare(String o1, String o2) {
            int diff = o1.length() - o2.length();
            if (diff == 0) {
                diff = -1;
            }
            return diff;
        }
    }
}

