/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.library.folder;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.library.folder.Algorithm;
import org.protege.editor.owl.model.library.folder.SAXParseCompletedException;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlBaseAlgorithm
implements Algorithm {
    private static Logger log = Logger.getLogger(XmlBaseAlgorithm.class);
    private InputStream is;
    private URI xmlBase;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<URI> getSuggestions(File f) {
        try {
            this.is = new FileInputStream(f);
            this.xmlBase = null;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(this.is, (DefaultHandler)new MyHandler());
        }
        catch (Throwable t) {
        }
        finally {
            try {
                this.is.close();
            }
            catch (Throwable t) {}
        }
        if (this.xmlBase == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.xmlBase);
    }

    private class MyHandler
    extends DefaultHandler {
        private MyHandler() {
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            for (int i = 0; i < atts.getLength(); ++i) {
                if (!atts.getQName(i).equals("xml:base")) continue;
                try {
                    XmlBaseAlgorithm.this.xmlBase = new URI(atts.getValue(i));
                    throw new SAXParseCompletedException();
                }
                catch (URISyntaxException e) {
                    log.error((Object)"Exception caught", (Throwable)e);
                }
            }
            throw new SAXException("No xml base");
        }
    }
}

