/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.inference;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.inference.DefaultOWLReasonerExceptionHandler;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.model.inference.NoOpReasonerFactory;
import org.protege.editor.owl.model.inference.NoOpReasonerInfo;
import org.protege.editor.owl.model.inference.OWLReasonerExceptionHandler;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerInfo;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerPlugin;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerPluginLoader;
import org.protege.editor.owl.model.inference.ReasonerDiedException;
import org.protege.editor.owl.model.inference.ReasonerFilter;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.inference.ReasonerStatus;
import org.protege.editor.owl.model.inference.ReasonerUtilities;
import org.protege.editor.owl.ui.explanation.io.InconsistentOntologyManager;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.InconsistentOntologyException;
import org.semanticweb.owlapi.reasoner.InferenceType;
import org.semanticweb.owlapi.reasoner.NullReasonerProgressMonitor;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.ReasonerProgressMonitor;

public class OWLReasonerManagerImpl
implements OWLReasonerManager {
    private static Logger logger = Logger.getLogger(OWLReasonerManager.class);
    private OWLModelManager owlModelManager;
    private ReasonerPreferences preferences;
    private Set<ProtegeOWLReasonerInfo> reasonerFactories;
    private ProtegeOWLReasonerInfo currentReasonerFactory;
    private Map<OWLOntology, OWLReasoner> reasonerMap = new HashMap<OWLOntology, OWLReasoner>();
    private OWLReasoner runningReasoner;
    private boolean classificationInProgress = false;
    private ReasonerProgressMonitor reasonerProgressMonitor;
    private OWLReasonerExceptionHandler exceptionHandler;
    private List<ReasonerFilter> reasonerFilters = new ArrayList<ReasonerFilter>();

    public OWLReasonerManagerImpl(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        this.preferences = new ReasonerPreferences();
        this.preferences.load();
        this.reasonerFactories = new HashSet<ProtegeOWLReasonerInfo>();
        this.reasonerProgressMonitor = new NullReasonerProgressMonitor();
        this.installFactories();
        this.exceptionHandler = new DefaultOWLReasonerExceptionHandler();
    }

    @Override
    public void setReasonerExceptionHandler(OWLReasonerExceptionHandler handler) {
        this.exceptionHandler = handler != null ? handler : new DefaultOWLReasonerExceptionHandler();
    }

    public void dispose() {
        if (this.preferences != null) {
            this.preferences.save();
        }
        this.clearAndDisposeReasoners();
    }

    private void clearAndDisposeReasoners() {
        for (OWLReasoner reasoner : this.reasonerMap.values()) {
            if (reasoner == null) continue;
            try {
                reasoner.dispose();
            }
            catch (Throwable t) {
                ProtegeApplication.getErrorLog().logError(t);
            }
        }
        this.reasonerMap.clear();
    }

    @Override
    public String getCurrentReasonerName() {
        return this.getCurrentReasoner().getReasonerName();
    }

    @Override
    public ProtegeOWLReasonerInfo getCurrentReasonerFactory() {
        if (this.currentReasonerFactory == null) {
            this.currentReasonerFactory = new NoOpReasonerInfo();
        }
        return this.currentReasonerFactory;
    }

    @Override
    public void setReasonerProgressMonitor(ReasonerProgressMonitor progressMonitor) {
        this.reasonerProgressMonitor = progressMonitor;
    }

    public ReasonerProgressMonitor getReasonerProgressMonitor() {
        return this.reasonerProgressMonitor;
    }

    @Override
    public Set<ProtegeOWLReasonerInfo> getInstalledReasonerFactories() {
        return this.reasonerFactories;
    }

    private void installFactories() {
        ProtegeOWLReasonerPluginLoader loader = new ProtegeOWLReasonerPluginLoader(this.owlModelManager);
        this.addReasonerFactories(loader.getPlugins());
        this.setCurrentReasonerFactoryId(this.preferences.getDefaultReasonerId());
    }

    public void addReasonerFactories(Set<ProtegeOWLReasonerPlugin> plugins) {
        for (ProtegeOWLReasonerPlugin plugin : plugins) {
            try {
                ProtegeOWLReasonerInfo factory = (ProtegeOWLReasonerInfo)plugin.newInstance();
                factory.initialise();
                this.reasonerFactories.add(factory);
            }
            catch (Throwable t) {
                ProtegeApplication.getErrorLog().logError(t);
            }
        }
    }

    @Override
    public String getCurrentReasonerFactoryId() {
        return this.getCurrentReasonerFactory().getReasonerId();
    }

    @Override
    public void setCurrentReasonerFactoryId(String id) {
        if (this.getCurrentReasonerFactory().getReasonerId().equals(id)) {
            return;
        }
        for (ProtegeOWLReasonerInfo reasonerFactory : this.reasonerFactories) {
            if (!reasonerFactory.getReasonerId().equals(id)) continue;
            this.preferences.setDefaultReasonerId(id);
            this.preferences.save();
            this.clearAndDisposeReasoners();
            this.currentReasonerFactory = reasonerFactory;
            this.owlModelManager.fireEvent(EventType.REASONER_CHANGED);
            return;
        }
        logger.warn((Object)("Reasoner with id " + id + " not found"));
        this.preferences.setDefaultReasonerId("org.protege.editor.owl.NoOpReasoner");
        this.preferences.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OWLReasoner getCurrentReasoner() {
        OWLReasoner reasoner;
        OWLOntology activeOntology = this.owlModelManager.getActiveOntology();
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            reasoner = this.reasonerMap.get(activeOntology);
        }
        if (reasoner == null) {
            reasoner = new NoOpReasoner(activeOntology);
            map = this.reasonerMap;
            synchronized (map) {
                this.reasonerMap.put(activeOntology, reasoner);
            }
        }
        return reasoner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killCurrentReasoner() {
        OWLReasoner reasoner = this.getCurrentReasoner();
        if (!(reasoner instanceof NoOpReasoner)) {
            try {
                reasoner.dispose();
            }
            catch (Exception ex) {
                ProtegeApplication.getErrorLog().logError((Throwable)ex);
            }
            Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
            synchronized (map) {
                this.reasonerMap.put(this.owlModelManager.getActiveOntology(), null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassificationInProgress() {
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            return this.classificationInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClassified() {
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            OWLReasoner reasoner = this.getCurrentReasoner();
            return !(reasoner instanceof NoOpReasoner) && (reasoner.getPendingChanges() == null || reasoner.getPendingChanges().isEmpty());
        }
    }

    @Override
    public ReasonerStatus getReasonerStatus() {
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            if (this.classificationInProgress) {
                return ReasonerStatus.INITIALIZATION_IN_PROGRESS;
            }
            if (this.currentReasonerFactory.getReasonerFactory() instanceof NoOpReasonerFactory) {
                return ReasonerStatus.NO_REASONER_FACTORY_CHOSEN;
            }
            OWLReasoner reasoner = this.getCurrentReasoner();
            try {
                if (reasoner instanceof NoOpReasoner) {
                    return ReasonerStatus.REASONER_NOT_INITIALIZED;
                }
                if (!reasoner.isConsistent()) {
                    return ReasonerStatus.INCONSISTENT;
                }
                if (reasoner.getPendingChanges().isEmpty()) {
                    return ReasonerStatus.INITIALIZED;
                }
                return ReasonerStatus.OUT_OF_SYNC;
            }
            catch (Exception e) {
                this.killCurrentReasoner();
                logger.warn((Object)"Reasoner died.");
                throw new ReasonerDiedException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean classifyAsynchronously(Set<InferenceType> precompute) {
        if (this.getCurrentReasonerFactory() instanceof NoOpReasonerInfo) {
            return true;
        }
        OWLOntology currentOntology = this.owlModelManager.getActiveOntology();
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            if (this.classificationInProgress) {
                return false;
            }
            this.runningReasoner = this.reasonerMap.get(currentOntology);
            this.reasonerMap.put(currentOntology, new NoOpReasoner(currentOntology));
            this.classificationInProgress = true;
        }
        this.owlModelManager.fireEvent(EventType.ABOUT_TO_CLASSIFY);
        Thread currentReasonerThread = new Thread((Runnable)new ClassificationRunner(currentOntology, precompute), "Classification Thread");
        currentReasonerThread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                ProtegeApplication.getErrorLog().logError(throwable);
                try {
                    if (OWLReasonerManagerImpl.this.getReasonerStatus() != ReasonerStatus.REASONER_NOT_INITIALIZED) {
                        OWLReasonerManagerImpl.this.exceptionHandler.handle(throwable);
                    }
                }
                catch (ReasonerDiedException died) {
                    ReasonerUtilities.warnThatReasonerDied(null, died);
                }
            }
        });
        currentReasonerThread.start();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void killCurrentClassification() {
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            if (this.runningReasoner != null) {
                this.runningReasoner.interrupt();
            }
        }
    }

    @Override
    public ReasonerPreferences getReasonerPreferences() {
        return this.preferences;
    }

    private void fireReclassified() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                OWLReasonerManagerImpl.this.owlModelManager.fireEvent(EventType.ONTOLOGY_CLASSIFIED);
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addReasonerFilter(ReasonerFilter filter) {
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            this.reasonerFilters.add(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OWLOntology applyReasonerFilters(OWLOntology ontology) {
        Map<OWLOntology, OWLReasoner> map = this.reasonerMap;
        synchronized (map) {
            for (ReasonerFilter filter : this.reasonerFilters) {
                ontology = filter.getFilteredOntology(ontology);
            }
        }
        return ontology;
    }

    private class ClassificationRunner
    implements Runnable {
        private OWLOntology ontology;
        private Set<InferenceType> precompute;
        private ProtegeOWLReasonerInfo currentReasonerFactory;

        public ClassificationRunner(OWLOntology ontology, Set<InferenceType> precompute) {
            this.ontology = ontology;
            this.precompute = EnumSet.noneOf(InferenceType.class);
            this.precompute.addAll(precompute);
            this.currentReasonerFactory = OWLReasonerManagerImpl.this.getCurrentReasonerFactory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean inconsistencyFound = false;
            boolean reasonerChanged = false;
            try {
                long start = System.currentTimeMillis();
                reasonerChanged = this.ensureRunningReasonerInitialized();
                if (OWLReasonerManagerImpl.this.runningReasoner != null) {
                    this.precompute();
                    logger.info((Object)(this.currentReasonerFactory.getReasonerName() + " classified in " + (System.currentTimeMillis() - start) + "ms"));
                }
            }
            catch (InconsistentOntologyException ioe) {
                inconsistencyFound = true;
            }
            finally {
                if (OWLReasonerManagerImpl.this.runningReasoner != null) {
                    OWLReasoner oWLReasoner = OWLReasonerManagerImpl.this.runningReasoner;
                    synchronized (oWLReasoner) {
                        OWLReasonerManagerImpl.this.reasonerFilters.clear();
                    }
                }
                this.installRunningReasoner(inconsistencyFound, reasonerChanged);
            }
        }

        public boolean ensureRunningReasonerInitialized() {
            boolean reasonerChanged = false;
            if (OWLReasonerManagerImpl.this.runningReasoner instanceof NoOpReasoner) {
                OWLReasonerManagerImpl.this.runningReasoner = null;
            }
            if (OWLReasonerManagerImpl.this.runningReasoner != null && !OWLReasonerManagerImpl.this.runningReasoner.getPendingChanges().isEmpty()) {
                if (OWLReasonerManagerImpl.this.runningReasoner.getBufferingMode() == null || OWLReasonerManagerImpl.this.runningReasoner.getBufferingMode() == BufferingMode.NON_BUFFERING) {
                    OWLReasonerManagerImpl.this.runningReasoner.dispose();
                    OWLReasonerManagerImpl.this.runningReasoner = null;
                } else {
                    OWLReasonerManagerImpl.this.runningReasoner.flush();
                }
            }
            if (OWLReasonerManagerImpl.this.runningReasoner == null) {
                OWLReasonerManagerImpl.this.runningReasoner = ReasonerUtilities.createReasoner(OWLReasonerManagerImpl.this.applyReasonerFilters(this.ontology), this.currentReasonerFactory, OWLReasonerManagerImpl.this.reasonerProgressMonitor);
                reasonerChanged = true;
            }
            if (OWLReasonerManagerImpl.this.runningReasoner == null) {
                OWLReasonerManagerImpl.this.classificationInProgress = false;
                ProtegeApplication.getErrorLog().logError((Throwable)new Exception("Reasoner Initialization failed (ontology is probably inconsistent)"));
            }
            return reasonerChanged;
        }

        public void precompute() {
            EnumSet<InferenceType> precomputeThisRun = EnumSet.noneOf(InferenceType.class);
            precomputeThisRun.addAll(this.precompute);
            precomputeThisRun.retainAll(OWLReasonerManagerImpl.this.runningReasoner.getPrecomputableInferenceTypes());
            if (!precomputeThisRun.isEmpty()) {
                logger.info((Object)"Initializing the reasoner by performing the following steps:");
                for (InferenceType type : this.precompute) {
                    logger.info((Object)("\t" + type));
                }
                OWLReasonerManagerImpl.this.runningReasoner.precomputeInferences(precomputeThisRun.toArray(new InferenceType[precomputeThisRun.size()]));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void installRunningReasoner(boolean inconsistencyFound, boolean reasonerChanged) {
            Map map = OWLReasonerManagerImpl.this.reasonerMap;
            synchronized (map) {
                OWLReasonerManagerImpl.this.reasonerMap.put(this.ontology, OWLReasonerManagerImpl.this.runningReasoner);
                OWLReasonerManagerImpl.this.runningReasoner = null;
                OWLReasonerManagerImpl.this.classificationInProgress = false;
            }
            if (reasonerChanged) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OWLReasonerManagerImpl.this.owlModelManager.fireEvent(EventType.REASONER_CHANGED);
                    }
                });
            }
            OWLReasonerManagerImpl.this.fireReclassified();
            if (inconsistencyFound) {
                InconsistentOntologyManager.get(OWLReasonerManagerImpl.this.owlModelManager).explain();
            }
        }
    }
}

