/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.history.HistoryManager;
import org.protege.editor.owl.model.history.ReverseChangeGenerator;
import org.protege.editor.owl.model.history.UndoManagerListener;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeVisitor;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public class HistoryManagerImpl
implements HistoryManager {
    private ChangeType typeOfChangeInProgress = ChangeType.NORMAL;
    private static Logger logger = Logger.getLogger(HistoryManager.class);
    private OWLOntologyManager manager;
    private Stack<List<OWLOntologyChange>> undoStack;
    private Stack<List<OWLOntologyChange>> redoStack;
    private List<UndoManagerListener> listeners;

    public HistoryManagerImpl(OWLModelManager owlModelManager) {
        this(owlModelManager.getOWLOntologyManager());
    }

    public HistoryManagerImpl(OWLOntologyManager manager) {
        this.manager = manager;
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.listeners = new ArrayList<UndoManagerListener>();
        this.typeOfChangeInProgress = ChangeType.NORMAL;
    }

    @Override
    public boolean canRedo() {
        return this.redoStack.size() > 0;
    }

    @Override
    public boolean canUndo() {
        return this.undoStack.size() > 0;
    }

    @Override
    public void logChanges(List<? extends OWLOntologyChange> changes) {
        switch (this.typeOfChangeInProgress) {
            case NORMAL: {
                this.redoStack.clear();
            }
            case REDOING: {
                this.undoStack.push(new ArrayList<OWLOntologyChange>(changes));
                break;
            }
            case UNDOING: {
                this.redoStack.push(this.reverseChanges(changes));
            }
        }
        this.fireStateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redo() {
        if (this.canRedo()) {
            try {
                this.typeOfChangeInProgress = ChangeType.REDOING;
                List<OWLOntologyChange> redoChanges = this.redoStack.pop();
                this.manager.applyChanges(redoChanges);
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                this.typeOfChangeInProgress = ChangeType.NORMAL;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undo() {
        if (this.canUndo()) {
            try {
                this.typeOfChangeInProgress = ChangeType.UNDOING;
                List<OWLOntologyChange> changes = this.undoStack.pop();
                this.manager.applyChanges(this.reverseChanges(changes));
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
            finally {
                this.typeOfChangeInProgress = ChangeType.NORMAL;
            }
        }
    }

    @Override
    public void addUndoManagerListener(UndoManagerListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeUndoManagerListener(UndoManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public List<List<OWLOntologyChange>> getLoggedChanges() {
        ArrayList<List<OWLOntologyChange>> copyOfLog = new ArrayList<List<OWLOntologyChange>>();
        for (List list : this.undoStack) {
            copyOfLog.add(new ArrayList(list));
        }
        return copyOfLog;
    }

    public void fireStateChanged() {
        for (UndoManagerListener listener : new ArrayList<UndoManagerListener>(this.listeners)) {
            listener.stateChanged(this);
        }
    }

    private List<OWLOntologyChange> reverseChanges(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLOntologyChange> reversedChanges = new ArrayList<OWLOntologyChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            ReverseChangeGenerator gen = new ReverseChangeGenerator();
            oWLOntologyChange.accept((OWLOntologyChangeVisitor)gen);
            reversedChanges.add(0, gen.getReverseChange());
        }
        return reversedChanges;
    }

    private static enum ChangeType {
        UNDOING,
        REDOING,
        NORMAL;

    }
}

