/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.property;

import java.util.HashSet;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.hierarchy.OWLObjectPropertyHierarchyProvider;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class InferredObjectPropertyHierarchyProvider
extends OWLObjectPropertyHierarchyProvider {
    private OWLModelManager mngr;
    public static final String ID = "inferredObjectPropertyHierarchyProvider";

    public InferredObjectPropertyHierarchyProvider(OWLModelManager mngr) {
        super(mngr.getOWLOntologyManager());
        this.mngr = mngr;
    }

    protected OWLReasoner getReasoner() {
        return this.mngr.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public Set<OWLObjectProperty> getChildren(OWLObjectProperty objectProperty) {
        Set subs = this.getReasoner().getSubObjectProperties((OWLObjectPropertyExpression)objectProperty, true).getFlattened();
        subs.remove(objectProperty);
        HashSet<OWLObjectProperty> children = new HashSet<OWLObjectProperty>();
        for (OWLObjectPropertyExpression p : subs) {
            if (!(p instanceof OWLObjectProperty)) continue;
            children.add((OWLObjectProperty)p);
        }
        return children;
    }

    @Override
    public Set<OWLObjectProperty> getParents(OWLObjectProperty objectProperty) {
        Set supers = this.getReasoner().getSuperObjectProperties((OWLObjectPropertyExpression)objectProperty, true).getFlattened();
        supers.remove(objectProperty);
        HashSet<OWLObjectProperty> parents = new HashSet<OWLObjectProperty>();
        for (OWLObjectPropertyExpression p : supers) {
            if (!(p instanceof OWLObjectProperty)) continue;
            parents.add((OWLObjectProperty)p);
        }
        return parents;
    }

    @Override
    public Set<OWLObjectProperty> getEquivalents(OWLObjectProperty objectProperty) {
        Set equivs = this.getReasoner().getEquivalentObjectProperties((OWLObjectPropertyExpression)objectProperty).getEntities();
        equivs.remove(objectProperty);
        HashSet<OWLObjectProperty> ret = new HashSet<OWLObjectProperty>();
        for (OWLObjectPropertyExpression p : equivs) {
            if (!(p instanceof OWLObjectProperty)) continue;
            ret.add((OWLObjectProperty)p);
        }
        return ret;
    }
}

