/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy.cls;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.protege.editor.owl.model.inference.NoOpReasoner;
import org.protege.editor.owl.model.inference.ReasonerDiedException;
import org.protege.editor.owl.model.inference.ReasonerStatus;
import org.protege.editor.owl.model.inference.ReasonerUtilities;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class InferredOWLClassHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLClass> {
    private static final Logger logger = Logger.getLogger(InferredOWLClassHierarchyProvider.class);
    private OWLModelManager owlModelManager;
    private OWLOntologyManager owlOntologyManager;
    private OWLClass owlThing;
    private OWLClass owlNothing;
    private OWLModelManagerListener owlModelManagerListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.REASONER_CHANGED) || event.isType(EventType.ACTIVE_ONTOLOGY_CHANGED) || event.isType(EventType.ONTOLOGY_CLASSIFIED) || event.isType(EventType.ONTOLOGY_RELOADED)) {
                InferredOWLClassHierarchyProvider.this.fireHierarchyChanged();
            }
        }
    };
    private OWLOntologyChangeListener owlOntologyChangeListener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
            OWLReasoner reasoner = InferredOWLClassHierarchyProvider.this.owlModelManager.getReasoner();
            if (!(reasoner instanceof NoOpReasoner) && reasoner.getBufferingMode() == BufferingMode.NON_BUFFERING) {
                boolean needsRefresh = false;
                for (OWLOntologyChange oWLOntologyChange : changes) {
                    if (!(oWLOntologyChange instanceof OWLAxiomChange) || !((OWLAxiomChange)oWLOntologyChange).getAxiom().isLogicalAxiom()) continue;
                    needsRefresh = true;
                    break;
                }
                if (needsRefresh) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                if (InferredOWLClassHierarchyProvider.this.owlModelManager.getOWLReasonerManager().getReasonerStatus() == ReasonerStatus.INITIALIZED) {
                                    InferredOWLClassHierarchyProvider.this.fireHierarchyChanged();
                                }
                            }
                            catch (ReasonerDiedException rde) {
                                ReasonerUtilities.warnThatReasonerDied(null, rde);
                            }
                        }
                    });
                }
            }
        }
    };

    public InferredOWLClassHierarchyProvider(OWLModelManager owlModelManager, OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.owlModelManager = owlModelManager;
        this.owlThing = owlModelManager.getOWLDataFactory().getOWLThing();
        this.owlNothing = owlModelManager.getOWLDataFactory().getOWLNothing();
        owlModelManager.addListener(this.owlModelManagerListener);
        owlOntologyManager.addOntologyChangeListener(this.owlOntologyChangeListener);
    }

    public void rebuild() {
    }

    @Override
    public void dispose() {
        super.dispose();
        this.owlModelManager.removeListener(this.owlModelManagerListener);
        this.owlModelManager.getOWLOntologyManager().removeOntologyChangeListener(this.owlOntologyChangeListener);
    }

    @Override
    public Set<OWLClass> getRoots() {
        return Collections.singleton(this.owlThing);
    }

    protected OWLReasoner getReasoner() {
        return this.owlModelManager.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public Set<OWLClass> getChildren(OWLClass object) {
        Set subs = this.getReasoner().getSubClasses((OWLClassExpression)object, true).getFlattened();
        if (object.isOWLThing() && !this.owlModelManager.getReasoner().getUnsatisfiableClasses().isSingleton()) {
            subs.add(this.owlNothing);
        } else if (object.isOWLNothing()) {
            subs.addAll(this.getReasoner().getUnsatisfiableClasses().getEntities());
            subs.remove(this.owlNothing);
        } else {
            subs.remove(this.owlNothing);
            Iterator it = subs.iterator();
            while (it.hasNext()) {
                if (this.getReasoner().isSatisfiable((OWLClassExpression)it.next())) continue;
                it.remove();
            }
        }
        return subs;
    }

    @Override
    public Set<OWLClass> getDescendants(OWLClass object) {
        return this.getReasoner().getSubClasses((OWLClassExpression)object, false).getFlattened();
    }

    @Override
    public Set<OWLClass> getParents(OWLClass object) {
        if (object.isOWLNothing()) {
            return Collections.singleton(this.owlThing);
        }
        if (!this.getReasoner().isSatisfiable((OWLClassExpression)object)) {
            return Collections.singleton(this.owlNothing);
        }
        Set parents = this.getReasoner().getSuperClasses((OWLClassExpression)object, true).getFlattened();
        parents.remove(object);
        return parents;
    }

    @Override
    public Set<OWLClass> getAncestors(OWLClass object) {
        return this.getReasoner().getSuperClasses((OWLClassExpression)object, false).getFlattened();
    }

    @Override
    public Set<OWLClass> getEquivalents(OWLClass object) {
        if (!this.getReasoner().isSatisfiable((OWLClassExpression)object)) {
            return Collections.emptySet();
        }
        Set equivalents = this.getReasoner().getEquivalentClasses((OWLClassExpression)object).getEntities();
        equivalents.remove(object);
        return equivalents;
    }

    @Override
    public boolean containsReference(OWLClass object) {
        return false;
    }

    protected void addRoot(OWLClass object) {
    }

    protected void removeRoot(OWLClass object) {
    }

    protected Set<OWLClass> getOrphanRoots(OWLClass object) {
        return Collections.emptySet();
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
    }
}

