/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLOntology;

public class OWLOntologyHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLOntology> {
    private Set<OWLOntology> roots;
    private Map<OWLOntology, Set<OWLOntology>> parent2ChildMap;
    private Map<OWLOntology, Set<OWLOntology>> child2ParentMap;
    private OWLModelManager mngr;
    private OWLModelManagerListener modelManagerListener = new OWLModelManagerListener(){

        @Override
        public void handleChange(OWLModelManagerChangeEvent event) {
            if (event.isType(EventType.ONTOLOGY_LOADED) || event.isType(EventType.ONTOLOGY_RELOADED) || event.isType(EventType.ONTOLOGY_CREATED)) {
                OWLOntologyHierarchyProvider.this.rebuild();
            }
        }
    };

    public OWLOntologyHierarchyProvider(OWLModelManager mngr) {
        super(mngr.getOWLOntologyManager());
        this.mngr = mngr;
        this.roots = new HashSet<OWLOntology>();
        this.parent2ChildMap = new HashMap<OWLOntology, Set<OWLOntology>>();
        this.child2ParentMap = new HashMap<OWLOntology, Set<OWLOntology>>();
        this.rebuild();
        mngr.addListener(this.modelManagerListener);
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
    }

    private void rebuild() {
        this.roots.clear();
        this.parent2ChildMap.clear();
        this.child2ParentMap.clear();
        for (OWLOntology ont : this.mngr.getOntologies()) {
            for (OWLOntology imp : this.mngr.getOWLOntologyManager().getImports(ont)) {
                this.add(ont, imp);
            }
        }
        for (OWLOntology ont : this.mngr.getOntologies()) {
            if (this.child2ParentMap.containsKey(ont)) continue;
            this.roots.add(ont);
        }
        this.fireHierarchyChanged();
    }

    private void add(OWLOntology ont, OWLOntology imp) {
        this.getChildren(ont, true).add(imp);
        this.getParents(imp, true).add(ont);
    }

    private Set<OWLOntology> getChildren(OWLOntology parent, boolean add) {
        Set<OWLOntology> children = this.parent2ChildMap.get(parent);
        if (children == null) {
            children = new HashSet<OWLOntology>();
            if (add) {
                this.parent2ChildMap.put(parent, children);
            }
        }
        return children;
    }

    private Set<OWLOntology> getParents(OWLOntology child, boolean add) {
        Set<OWLOntology> parents = this.child2ParentMap.get(child);
        if (parents == null) {
            parents = new HashSet<OWLOntology>();
            if (add) {
                this.child2ParentMap.put(child, parents);
            }
        }
        return parents;
    }

    @Override
    public Set<OWLOntology> getRoots() {
        return Collections.unmodifiableSet(this.roots);
    }

    @Override
    public Set<OWLOntology> getParents(OWLOntology object) {
        return this.getParents(object, true);
    }

    @Override
    public Set<OWLOntology> getEquivalents(OWLOntology object) {
        return Collections.emptySet();
    }

    @Override
    public Set<OWLOntology> getChildren(OWLOntology object) {
        return this.getChildren(object, true);
    }

    @Override
    public boolean containsReference(OWLOntology object) {
        return this.parent2ChildMap.containsKey(object) || this.roots.contains(object);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mngr.removeListener(this.modelManagerListener);
    }
}

