/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;

public class IndividualsByInferredTypeHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLObject> {
    private static final Logger logger = Logger.getLogger(IndividualsByInferredTypeHierarchyProvider.class);
    private Map<OWLObject, Set<OWLObject>> typeNodes = new HashMap<OWLObject, Set<OWLObject>>();
    private OWLReasoner reasoner;
    private boolean showDirect = true;

    public IndividualsByInferredTypeHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
    }

    public void setReasoner(OWLReasoner reasoner) {
        this.reasoner = reasoner;
        this.rebuild();
    }

    private void rebuild() {
        this.typeNodes.clear();
        if (this.reasoner != null) {
            Set importsClosure = this.reasoner.getRootOntology().getImportsClosure();
            for (OWLOntology ont : importsClosure) {
                for (OWLClass cls : ont.getClassesInSignature()) {
                    Set inds = this.reasoner.getInstances((OWLClassExpression)cls, this.showDirect).getFlattened();
                    if (inds.isEmpty()) continue;
                    this.typeNodes.put((OWLObject)cls, new HashSet(inds));
                }
            }
        }
        this.fireHierarchyChanged();
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
        throw new RuntimeException("Use setReasoner()");
    }

    @Override
    public Set<OWLObject> getRoots() {
        return this.typeNodes.keySet();
    }

    @Override
    public Set<OWLObject> getChildren(OWLObject object) {
        if (this.reasoner != null && this.typeNodes.containsKey(object)) {
            return this.typeNodes.get(object);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<OWLObject> getParents(OWLObject object) {
        if (this.reasoner != null && this.typeNodes.containsKey(object)) {
            return Collections.emptySet();
        }
        OWLNamedIndividual ind = (OWLNamedIndividual)object;
        HashSet<OWLObject> clses = new HashSet<OWLObject>();
        for (OWLClass cls : this.reasoner.getTypes(ind, this.showDirect).getFlattened()) {
            clses.add((OWLObject)cls);
        }
        return clses;
    }

    @Override
    public Set<OWLObject> getEquivalents(OWLObject object) {
        return Collections.emptySet();
    }

    @Override
    public boolean containsReference(OWLObject object) {
        return true;
    }

    @Override
    public void dispose() {
        super.dispose();
    }
}

