/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.protege.owlapi.inference.cls.ChildClassExtractor;
import org.protege.owlapi.inference.cls.ParentClassExtractor;
import org.protege.owlapi.inference.orphan.Relation;
import org.protege.owlapi.inference.orphan.TerminalElementFinder;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLAxiomVisitor;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.RemoveAxiom;

public class AssertedClassHierarchyProvider
extends AbstractOWLObjectHierarchyProvider<OWLClass> {
    private OWLOntologyManager owlOntologyManager;
    private Collection<OWLOntology> ontologies;
    private OWLClass root;
    private ParentClassExtractor parentClassExtractor;
    private ChildClassExtractor childClassExtractor;
    private OWLOntologyChangeListener listener;
    private TerminalElementFinder<OWLClass> rootFinder;
    private Set<OWLClass> nodesToUpdate = new HashSet<OWLClass>();

    public AssertedClassHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.owlOntologyManager = owlOntologyManager;
        this.ontologies = new ArrayList<OWLOntology>();
        this.rootFinder = new TerminalElementFinder((Relation)new Relation<OWLClass>(){

            public Collection<OWLClass> getR(OWLClass cls) {
                Set<OWLClass> parents = AssertedClassHierarchyProvider.this.getParents(cls);
                parents.remove(AssertedClassHierarchyProvider.this.root);
                return parents;
            }
        });
        this.parentClassExtractor = new ParentClassExtractor();
        this.childClassExtractor = new ChildClassExtractor();
        this.listener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
                AssertedClassHierarchyProvider.this.handleChanges(changes);
            }
        };
        this.getManager().addOntologyChangeListener(this.listener);
    }

    @Override
    public void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies = new ArrayList<OWLOntology>(ontologies);
        this.nodesToUpdate.clear();
        if (this.root == null) {
            this.root = this.owlOntologyManager.getOWLDataFactory().getOWLThing();
        }
        this.rebuildImplicitRoots();
        this.fireHierarchyChanged();
    }

    private void rebuildImplicitRoots() {
        this.rootFinder.clear();
        for (OWLOntology ont : this.ontologies) {
            Set ref = ont.getClassesInSignature();
            this.rootFinder.appendTerminalElements(ref);
        }
        this.rootFinder.finish();
    }

    @Override
    public void dispose() {
        this.getManager().removeOntologyChangeListener(this.listener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet oldTerminalElements = new HashSet(this.rootFinder.getTerminalElements());
        HashSet<OWLClass> changedClasses = new HashSet<OWLClass>();
        changedClasses.add(this.root);
        List<OWLAxiomChange> filteredChanges = this.filterIrrelevantChanges(changes);
        this.updateImplicitRoots(filteredChanges);
        for (OWLAxiomChange change : filteredChanges) {
            for (OWLEntity entity : change.getEntities()) {
                if (!(entity instanceof OWLClass) || entity.equals(this.root)) continue;
                changedClasses.add((OWLClass)entity);
            }
        }
        for (OWLClass cls : changedClasses) {
            this.registerNodeChanged(cls);
        }
        for (OWLClass cls : this.rootFinder.getTerminalElements()) {
            if (oldTerminalElements.contains(cls)) continue;
            this.registerNodeChanged(cls);
        }
        for (OWLClass cls : oldTerminalElements) {
            if (this.rootFinder.getTerminalElements().contains(cls)) continue;
            this.registerNodeChanged(cls);
        }
        this.notifyNodeChanges();
    }

    private List<OWLAxiomChange> filterIrrelevantChanges(List<? extends OWLOntologyChange> changes) {
        ArrayList<OWLAxiomChange> filteredChanges = new ArrayList<OWLAxiomChange>();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!this.ontologies.contains(oWLOntologyChange.getOntology()) || !oWLOntologyChange.isAxiomChange()) continue;
            filteredChanges.add((OWLAxiomChange)oWLOntologyChange);
        }
        return filteredChanges;
    }

    private void registerNodeChanged(OWLClass node) {
        this.nodesToUpdate.add(node);
    }

    private void notifyNodeChanges() {
        for (OWLClass node : this.nodesToUpdate) {
            this.fireNodeChanged(node);
        }
        this.nodesToUpdate.clear();
    }

    private void updateImplicitRoots(List<OWLAxiomChange> changes) {
        HashSet<OWLClass> possibleTerminalElements = new HashSet<OWLClass>();
        HashSet<OWLClass> notInOntologies = new HashSet<OWLClass>();
        for (OWLAxiomChange change : changes) {
            if (!this.ontologies.contains(change.getOntology()) || !change.isAxiomChange()) continue;
            boolean remove = change instanceof RemoveAxiom;
            OWLAxiom axiom = change.getAxiom();
            for (OWLEntity entity : axiom.getSignature()) {
                if (!(entity instanceof OWLClass) || entity.equals(this.root)) continue;
                OWLClass cls = (OWLClass)entity;
                if (remove && !this.containsReference(cls)) {
                    notInOntologies.add(cls);
                    continue;
                }
                possibleTerminalElements.add(cls);
            }
        }
        possibleTerminalElements.addAll(this.rootFinder.getTerminalElements());
        possibleTerminalElements.removeAll(notInOntologies);
        this.rootFinder.findTerminalElements(possibleTerminalElements);
    }

    @Override
    public Set<OWLClass> getRoots() {
        if (this.root == null) {
            this.root = this.owlOntologyManager.getOWLDataFactory().getOWLThing();
        }
        return Collections.singleton(this.root);
    }

    @Override
    public Set<OWLClass> getChildren(OWLClass object) {
        Set<Object> result;
        if (object.equals(this.root)) {
            result = new HashSet();
            result.addAll(this.rootFinder.getTerminalElements());
            result.addAll(this.extractChildren(object));
            result.remove(object);
        } else {
            result = this.extractChildren(object);
            Iterator<Object> it = result.iterator();
            while (it.hasNext()) {
                OWLClass curChild = (OWLClass)it.next();
                if (!this.getAncestors(object).contains(curChild)) continue;
                it.remove();
            }
        }
        return result;
    }

    private Set<OWLClass> extractChildren(OWLClass parent) {
        this.childClassExtractor.setCurrentParentClass(parent);
        for (OWLOntology ont : this.ontologies) {
            for (OWLAxiom ax : ont.getReferencingAxioms((OWLEntity)parent)) {
                if (!ax.isLogicalAxiom()) continue;
                ax.accept((OWLAxiomVisitor)this.childClassExtractor);
            }
        }
        return this.childClassExtractor.getResult();
    }

    @Override
    public boolean containsReference(OWLClass object) {
        for (OWLOntology ont : this.ontologies) {
            if (!ont.containsClassInSignature(object.getIRI())) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<OWLClass> getParents(OWLClass object) {
        if (object.equals(this.root)) {
            return Collections.emptySet();
        }
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        if (this.rootFinder.getTerminalElements().contains(object)) {
            result.add(this.root);
        }
        this.parentClassExtractor.reset();
        this.parentClassExtractor.setCurrentClass(object);
        for (OWLOntology ont : this.ontologies) {
            for (OWLClassAxiom ax : ont.getAxioms(object)) {
                ax.accept((OWLAxiomVisitor)this.parentClassExtractor);
            }
        }
        result.addAll(this.parentClassExtractor.getResult());
        return result;
    }

    @Override
    public Set<OWLClass> getEquivalents(OWLClass object) {
        HashSet<OWLClass> result = new HashSet<OWLClass>();
        for (OWLOntology ont : this.ontologies) {
            for (OWLClassExpression equiv : object.getEquivalentClasses(ont)) {
                if (equiv.isAnonymous()) continue;
                result.add((OWLClass)equiv);
            }
        }
        Set<OWLClass> ancestors = this.getAncestors(object);
        if (ancestors.contains(object)) {
            for (OWLClass cls : ancestors) {
                if (!this.getAncestors(cls).contains(object)) continue;
                result.add(cls);
            }
            result.remove(object);
            result.remove(this.root);
        }
        return result;
    }
}

