/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLPropertyExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLPropertyRange;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;

public abstract class AbstractOWLPropertyHierarchyProvider<R extends OWLPropertyRange, E extends OWLPropertyExpression<R, E>, P extends E>
extends AbstractOWLObjectHierarchyProvider<P> {
    private Set<OWLOntology> ontologies;
    private Set<P> subPropertiesOfRoot = new HashSet<P>();
    private OWLOntologyChangeListener listener;

    public AbstractOWLPropertyHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        super(owlOntologyManager);
        this.ontologies = new HashSet<OWLOntology>();
        this.listener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
                AbstractOWLPropertyHierarchyProvider.this.handleChanges(changes);
            }
        };
        owlOntologyManager.addOntologyChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.getManager().removeOntologyChangeListener(this.listener);
    }

    private void handleChanges(List<? extends OWLOntologyChange> changes) {
        HashSet<P> properties = new HashSet<P>(this.getPropertiesReferencedInChange(changes));
        for (OWLPropertyExpression prop : properties) {
            if (this.isSubPropertyOfRoot(prop)) {
                this.subPropertiesOfRoot.add(prop);
                this.fireNodeChanged(this.getRoot());
            } else if (this.getAncestors(prop).contains(prop)) {
                this.subPropertiesOfRoot.add(prop);
                for (OWLPropertyExpression anc : this.getAncestors(prop)) {
                    if (!this.getAncestors(anc).contains(prop)) continue;
                    this.subPropertiesOfRoot.add(anc);
                    this.fireNodeChanged(anc);
                }
            } else {
                this.subPropertiesOfRoot.remove(prop);
            }
            this.fireNodeChanged(prop);
        }
        this.fireNodeChanged(this.getRoot());
    }

    protected abstract Set<P> getPropertiesReferencedInChange(List<? extends OWLOntologyChange> var1);

    private boolean isSubPropertyOfRoot(P prop) {
        if (prop.equals(this.getRoot())) {
            return false;
        }
        Set<P> parents = this.getParents(prop);
        if (parents.isEmpty() || parents.contains(this.getRoot())) {
            for (OWLOntology ont : this.ontologies) {
                if (!this.containsReference(ont, prop)) continue;
                return true;
            }
        }
        return this.getAncestors(prop).contains(prop);
    }

    private void rebuildRoots() {
        this.subPropertiesOfRoot.clear();
        for (OWLOntology ontology : this.ontologies) {
            for (OWLPropertyExpression prop : this.getReferencedProperties(ontology)) {
                if (!this.isSubPropertyOfRoot(prop)) continue;
                this.subPropertiesOfRoot.add(prop);
            }
        }
    }

    protected abstract boolean containsReference(OWLOntology var1, P var2);

    protected abstract Set<? extends P> getReferencedProperties(OWLOntology var1);

    protected abstract Set<? extends OWLSubPropertyAxiom> getSubPropertyAxiomForRHS(P var1, OWLOntology var2);

    protected abstract P getRoot();

    @Override
    public Set<P> getRoots() {
        return Collections.singleton(this.getRoot());
    }

    @Override
    public final void setOntologies(Set<OWLOntology> ontologies) {
        this.ontologies.clear();
        this.ontologies.addAll(ontologies);
        this.rebuildRoots();
        this.fireHierarchyChanged();
    }

    @Override
    public boolean containsReference(P object) {
        for (OWLOntology ont : this.ontologies) {
            if (!this.getReferencedProperties(ont).contains(object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<P> getChildren(P object) {
        if (object.equals(this.getRoot())) {
            return Collections.unmodifiableSet(this.subPropertiesOfRoot);
        }
        HashSet<OWLPropertyExpression> result = new HashSet<OWLPropertyExpression>();
        for (OWLPropertyExpression subProp : object.getSubProperties(this.ontologies)) {
            if (subProp.isAnonymous() || this.getAncestors(subProp).contains(subProp)) continue;
            result.add(subProp);
        }
        return result;
    }

    @Override
    public Set<P> getEquivalents(P object) {
        HashSet<OWLPropertyExpression> result = new HashSet<OWLPropertyExpression>();
        Set<P> ancestors = this.getAncestors(object);
        if (ancestors.contains(object)) {
            for (OWLPropertyExpression anc : ancestors) {
                if (!this.getAncestors(anc).contains(object)) continue;
                result.add(anc);
            }
        }
        for (OWLPropertyExpression prop : object.getEquivalentProperties(this.ontologies)) {
            if (prop.isAnonymous()) continue;
            result.add(prop);
        }
        result.remove(object);
        return result;
    }

    @Override
    public Set<P> getParents(P object) {
        if (object.equals(this.getRoot())) {
            return Collections.emptySet();
        }
        HashSet<Object> result = new HashSet<Object>();
        for (OWLPropertyExpression prop : object.getSuperProperties(this.ontologies)) {
            if (prop.isAnonymous()) continue;
            result.add(prop);
        }
        if (result.isEmpty() && this.isReferenced(object)) {
            result.add(this.getRoot());
        }
        return result;
    }

    private boolean isReferenced(P e) {
        return (Boolean)e.accept((OWLPropertyExpressionVisitorEx)new IsReferencePropertyExpressionVisitor());
    }

    private class IsReferencePropertyExpressionVisitor
    implements OWLPropertyExpressionVisitorEx<Boolean> {
        private IsReferencePropertyExpressionVisitor() {
        }

        public Boolean visit(OWLObjectProperty property) {
            return this.isReferenced((OWLEntity)property);
        }

        public Boolean visit(OWLObjectInverseOf property) {
            return (Boolean)property.getInverse().accept((OWLPropertyExpressionVisitorEx)this);
        }

        public Boolean visit(OWLDataProperty property) {
            return this.isReferenced((OWLEntity)property);
        }

        private boolean isReferenced(OWLEntity e) {
            for (OWLOntology ontology : AbstractOWLPropertyHierarchyProvider.this.ontologies) {
                if (!ontology.containsEntityInSignature(e)) continue;
                return true;
            }
            return false;
        }
    }
}

