/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.hierarchy.AbstractOWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLOntologyObjectHierarchyProvider;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class AbstractOWLOntologyObjectHierarchyProvider<N extends OWLObject>
extends AbstractOWLObjectHierarchyProvider<N>
implements OWLOntologyObjectHierarchyProvider<N> {
    public static final Logger logger = Logger.getLogger(AbstractOWLOntologyObjectHierarchyProvider.class);
    private Set<OWLOntology> ontologies = new HashSet<OWLOntology>();
    private OWLOntologyChangeListener listener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            AbstractOWLOntologyObjectHierarchyProvider.this.handleOntologyChanges(changes);
        }
    };

    protected AbstractOWLOntologyObjectHierarchyProvider(OWLOntologyManager manager) {
        super(manager);
        this.attachListeners();
    }

    public Set<OWLOntology> getOntologies() {
        return Collections.unmodifiableSet(this.ontologies);
    }

    private void attachListeners() {
        this.getManager().addOntologyChangeListener(this.listener);
    }

    private void detachListeners() {
        this.getManager().removeOntologyChangeListener(this.listener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.detachListeners();
    }
}

