/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.hierarchy;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProvider;
import org.protege.editor.owl.model.hierarchy.OWLObjectHierarchyProviderListener;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyManager;

public abstract class AbstractOWLObjectHierarchyProvider<N extends OWLObject>
implements OWLObjectHierarchyProvider<N> {
    private static final Logger logger = Logger.getLogger(AbstractOWLObjectHierarchyProvider.class);
    private boolean fireEvents;
    private List<OWLObjectHierarchyProviderListener<N>> listeners;
    private OWLOntologyManager manager;

    protected AbstractOWLObjectHierarchyProvider(OWLOntologyManager owlOntologyManager) {
        this.manager = owlOntologyManager;
        this.listeners = new ArrayList<OWLObjectHierarchyProviderListener<N>>();
        this.fireEvents = true;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    @Override
    public void dispose() {
        this.listeners.clear();
    }

    @Override
    public Set<N> getAncestors(N object) {
        HashSet results = new HashSet();
        this.getAncestors(results, object);
        return results;
    }

    private void getAncestors(Set<N> results, N object) {
        for (OWLObject parent : this.getParents(object)) {
            if (results.contains(parent)) continue;
            results.add(parent);
            this.getAncestors(results, parent);
        }
    }

    @Override
    public Set<N> getDescendants(N object) {
        HashSet results = new HashSet();
        this.getDescendants(results, object);
        return results;
    }

    private void getDescendants(Set<N> results, N object) {
        for (OWLObject child : this.getChildren(object)) {
            if (results.contains(child)) continue;
            results.add(child);
            this.getDescendants(results, child);
        }
    }

    @Override
    public Set<List<N>> getPathsToRoot(N obj) {
        return this.setOfPaths(obj, new HashSet());
    }

    private Set<List<N>> setOfPaths(N obj, Set<N> processed) {
        if (this.getRoots().contains(obj)) {
            return this.getSingleSetOfLists(obj);
        }
        HashSet<List<N>> paths = new HashSet<List<N>>();
        for (OWLObject par : this.getParents(obj)) {
            if (processed.contains(par)) continue;
            processed.add(par);
            paths.addAll(this.append(obj, this.setOfPaths(par, processed)));
        }
        return paths;
    }

    private Set<List<N>> getSingleSetOfLists(N obj) {
        HashSet<List<N>> set = new HashSet<List<N>>();
        ArrayList<N> list = new ArrayList<N>();
        list.add(obj);
        set.add(list);
        return set;
    }

    private Set<List<N>> append(N obj, Set<List<N>> setOfPaths) {
        for (List<N> path : setOfPaths) {
            path.add(obj);
        }
        return setOfPaths;
    }

    private Set<N> createSet() {
        return new HashSet();
    }

    protected void setFireEvents(boolean b) {
        this.fireEvents = b;
    }

    @Override
    public void addListener(OWLObjectHierarchyProviderListener<N> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(OWLObjectHierarchyProviderListener<N> listener) {
        this.listeners.remove(listener);
    }

    protected void fireNodeChanged(N node) {
        if (!this.fireEvents) {
            return;
        }
        for (OWLObjectHierarchyProviderListener<N> listener : new ArrayList<OWLObjectHierarchyProviderListener<N>>(this.listeners)) {
            try {
                listener.nodeChanged(node);
            }
            catch (Throwable e) {
                e.printStackTrace();
                logger.warn((Object)(this.getClass().getName() + ": Listener" + listener + " has thrown an exception.  Removing bad listener!"));
                this.listeners.remove(listener);
                throw new RuntimeException(e);
            }
        }
    }

    protected void fireHierarchyChanged() {
        if (!this.fireEvents) {
            return;
        }
        for (OWLObjectHierarchyProviderListener<N> listener : new ArrayList<OWLObjectHierarchyProviderListener<N>>(this.listeners)) {
            try {
                listener.hierarchyChanged();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }
}

