/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.entity;

import java.util.Stack;
import java.util.UUID;
import org.protege.editor.owl.model.entity.AbstractIDGenerator;
import org.protege.editor.owl.model.entity.AutoIDException;
import org.protege.editor.owl.model.entity.AutoIDGenerator;
import org.protege.editor.owl.model.entity.Revertable;
import org.semanticweb.owlapi.model.OWLEntity;

public class UniqueIdGenerator
extends AbstractIDGenerator
implements AutoIDGenerator,
Revertable {
    private UUID nextId = UUID.randomUUID();
    private Stack<UUID> checkpoints = new Stack();

    @Override
    public String getNextID(Class<? extends OWLEntity> type) throws AutoIDException {
        UUID id = this.nextId;
        this.nextId = UUID.randomUUID();
        return this.getPrefix(type) + id.toString().replace("-", "_") + this.getSuffix(type);
    }

    @Override
    protected long getRawID(Class<? extends OWLEntity> type) throws AutoIDException {
        throw new UnsupportedOperationException("Shouldn't get here");
    }

    @Override
    public void checkpoint() {
        this.checkpoints.push(this.nextId);
    }

    @Override
    public void revert() {
        this.nextId = this.checkpoints.pop();
    }
}

