/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.classexpression.anonymouscls;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.parser.OWLParseException;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLObjectVisitorAdapter;

public class ADCFactory
extends OWLObjectVisitorAdapter {
    private static final Logger logger = Logger.getLogger(ADCFactory.class);
    private AnonymousDefinedClassManager adcManager;
    private Set<OWLClassExpression> descrs = new HashSet<OWLClassExpression>();

    public ADCFactory(AnonymousDefinedClassManager adcManager) {
        this.adcManager = adcManager;
    }

    public List<OWLOntologyChange> getADCsForOntology(OWLOntology ont) {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        this.descrs.clear();
        for (OWLClassAxiom ax : ont.getGeneralClassAxioms()) {
            ax.accept((OWLObjectVisitor)this);
        }
        for (OWLAnnotation annotation : ont.getAnnotations()) {
            annotation.accept((OWLObjectVisitor)this);
        }
        for (OWLClassExpression descr : this.descrs) {
            OWLEntityCreationSet<OWLClass> chSet = this.adcManager.createAnonymousClass(ont, descr);
            changes.addAll(chSet.getOntologyChanges());
        }
        return changes;
    }

    public void visit(OWLSubClassOfAxiom ax) {
        if (ax.getSubClass().isAnonymous()) {
            this.descrs.add(ax.getSubClass());
        }
    }

    public void visit(OWLEquivalentClassesAxiom ax) {
        for (OWLClassExpression descr : ax.getClassExpressions()) {
            if (!descr.isAnonymous()) continue;
            this.descrs.add(descr);
        }
    }

    public void visit(OWLAnnotation annotation) {
        if (annotation.getProperty().getIRI().equals(this.adcManager.getURI())) {
            annotation.getValue().accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLLiteral node) {
        try {
            OWLClassExpression descr = this.parseOWLClassExpression(node.getLiteral());
            this.descrs.add(descr);
        }
        catch (OWLParseException e) {
            logger.error((Object)e);
        }
    }

    private OWLClassExpression parseOWLClassExpression(String s) throws OWLParseException {
        throw new OWLParseException("Retrieving ADCs from annotations not currently implemented");
    }
}

