/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.util.OWLDataTypeUtils;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEntityVisitor;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLEntityRenderingCacheImpl
implements OWLEntityRenderingCache {
    private static final Logger logger = Logger.getLogger(OWLEntityRenderingCacheImpl.class);
    private Map<String, OWLClass> owlClassMap = new HashMap<String, OWLClass>();
    private Map<String, OWLObjectProperty> owlObjectPropertyMap = new HashMap<String, OWLObjectProperty>();
    private Map<String, OWLDataProperty> owlDataPropertyMap = new HashMap<String, OWLDataProperty>();
    private Map<String, OWLAnnotationProperty> owlAnnotationPropertyMap = new HashMap<String, OWLAnnotationProperty>();
    private Map<String, OWLNamedIndividual> owlIndividualMap = new HashMap<String, OWLNamedIndividual>();
    private Map<String, OWLDatatype> owlDatatypeMap = new HashMap<String, OWLDatatype>();
    private Map<OWLEntity, String> entityRenderingMap = new HashMap<OWLEntity, String>();
    private OWLModelManager owlModelManager;
    private OWLOntologyChangeListener listener = new OWLOntologyChangeListener(){

        public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
            OWLEntityRenderingCacheImpl.this.processChanges(changes);
        }
    };

    @Override
    public void setOWLModelManager(OWLModelManager owlModelManager) {
        this.owlModelManager = owlModelManager;
        owlModelManager.addOntologyChangeListener(this.listener);
    }

    private void processChanges(List<? extends OWLOntologyChange> changes) {
        HashSet changedEntities = new HashSet();
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!(oWLOntologyChange instanceof OWLAxiomChange)) continue;
            OWLAxiomChange chg = (OWLAxiomChange)oWLOntologyChange;
            changedEntities.addAll(chg.getEntities());
        }
        for (OWLEntity oWLEntity : changedEntities) {
            this.updateRendering(oWLEntity);
        }
    }

    @Override
    public void rebuild() {
        this.clear();
        OWLModelManagerEntityRenderer entityRenderer = this.owlModelManager.getOWLEntityRenderer();
        OWLDataFactory factory = this.owlModelManager.getOWLDataFactory();
        this.addRendering(factory.getOWLThing(), this.owlClassMap);
        this.addRendering(factory.getOWLNothing(), this.owlClassMap);
        this.addRendering(factory.getOWLTopObjectProperty(), this.owlObjectPropertyMap);
        this.addRendering(factory.getOWLBottomObjectProperty(), this.owlObjectPropertyMap);
        this.addRendering(factory.getOWLTopDataProperty(), this.owlDataPropertyMap);
        this.addRendering(factory.getOWLBottomDataProperty(), this.owlDataPropertyMap);
        for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
            for (OWLClass cls : ont.getClassesInSignature()) {
                this.addRendering(cls, this.owlClassMap);
            }
            for (OWLObjectProperty prop : ont.getObjectPropertiesInSignature()) {
                this.addRendering(prop, this.owlObjectPropertyMap);
            }
            for (OWLObjectProperty prop : ont.getDataPropertiesInSignature()) {
                this.addRendering((OWLEntity)prop, (Map)this.owlDataPropertyMap);
            }
            for (OWLNamedIndividual ind : ont.getIndividualsInSignature()) {
                if (ind.isAnonymous()) continue;
                this.addRendering(ind.asOWLNamedIndividual(), this.owlIndividualMap);
            }
            for (OWLObjectProperty prop : ont.getAnnotationPropertiesInSignature()) {
                this.addRendering((OWLEntity)prop, (Map)this.owlAnnotationPropertyMap);
            }
        }
        for (IRI uri : OWLRDFVocabulary.BUILT_IN_ANNOTATION_PROPERTY_IRIS) {
            this.addRendering(factory.getOWLAnnotationProperty(uri), this.owlAnnotationPropertyMap);
        }
        OWLDataTypeUtils datatypeUtils = new OWLDataTypeUtils(this.owlModelManager.getOWLOntologyManager());
        for (OWLDatatype dt : datatypeUtils.getKnownDatatypes(this.owlModelManager.getActiveOntologies())) {
            this.addRendering(dt, this.owlDatatypeMap);
        }
    }

    public void dispose() {
        this.clear();
        this.owlModelManager.removeOntologyChangeListener(this.listener);
    }

    private void clear() {
        this.owlClassMap.clear();
        this.owlObjectPropertyMap.clear();
        this.owlDataPropertyMap.clear();
        this.owlAnnotationPropertyMap.clear();
        this.owlIndividualMap.clear();
        this.owlDatatypeMap.clear();
        this.entityRenderingMap.clear();
    }

    @Override
    public OWLClass getOWLClass(String rendering) {
        return this.owlClassMap.get(rendering);
    }

    @Override
    public OWLObjectProperty getOWLObjectProperty(String rendering) {
        return this.owlObjectPropertyMap.get(rendering);
    }

    @Override
    public OWLDataProperty getOWLDataProperty(String rendering) {
        return this.owlDataPropertyMap.get(rendering);
    }

    @Override
    public OWLAnnotationProperty getOWLAnnotationProperty(String rendering) {
        return this.owlAnnotationPropertyMap.get(rendering);
    }

    @Override
    public OWLNamedIndividual getOWLIndividual(String rendering) {
        return this.owlIndividualMap.get(rendering);
    }

    @Override
    public OWLDatatype getOWLDatatype(String rendering) {
        return this.owlDatatypeMap.get(rendering);
    }

    @Override
    public String getRendering(OWLEntity owlEntity) {
        return this.entityRenderingMap.get(owlEntity);
    }

    @Override
    public OWLEntity getOWLEntity(String rendering) {
        OWLClass entity = this.getOWLClass(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLObjectProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDataProperty(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLIndividual(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLDatatype(rendering);
        if (entity != null) {
            return entity;
        }
        entity = this.getOWLAnnotationProperty(rendering);
        if (entity != null) {
            return entity;
        }
        return null;
    }

    @Override
    public void addRendering(OWLEntity owlEntity) {
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, OWLEntityRenderingCacheImpl.this.owlDataPropertyMap);
            }

            public void visit(OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap);
            }

            public void visit(OWLAnnotationProperty owlAnnotationProperty) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)owlAnnotationProperty, OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap);
            }

            public void visit(OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, OWLEntityRenderingCacheImpl.this.owlIndividualMap);
            }

            public void visit(OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, OWLEntityRenderingCacheImpl.this.owlClassMap);
            }

            public void visit(OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.addRendering((OWLEntity)entity, OWLEntityRenderingCacheImpl.this.owlDatatypeMap);
            }
        });
    }

    private <T extends OWLEntity> void addRendering(T entity, Map<String, T> map) {
        if (!this.entityRenderingMap.containsKey(entity)) {
            String rendering = this.owlModelManager.getRendering((OWLObject)entity);
            map.put(rendering, entity);
            this.entityRenderingMap.put(entity, rendering);
        }
    }

    @Override
    public void removeRendering(OWLEntity owlEntity) {
        final String oldRendering = this.entityRenderingMap.get(owlEntity);
        this.entityRenderingMap.remove(owlEntity);
        owlEntity.accept(new OWLEntityVisitor(){

            public void visit(OWLClass entity) {
                OWLEntityRenderingCacheImpl.this.owlClassMap.remove(oldRendering);
            }

            public void visit(OWLDataProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlDataPropertyMap.remove(oldRendering);
            }

            public void visit(OWLObjectProperty entity) {
                OWLEntityRenderingCacheImpl.this.owlObjectPropertyMap.remove(oldRendering);
            }

            public void visit(OWLAnnotationProperty owlAnnotationProperty) {
                OWLEntityRenderingCacheImpl.this.owlAnnotationPropertyMap.remove(oldRendering);
            }

            public void visit(OWLNamedIndividual entity) {
                OWLEntityRenderingCacheImpl.this.owlIndividualMap.remove(oldRendering);
            }

            public void visit(OWLDatatype entity) {
                OWLEntityRenderingCacheImpl.this.owlDatatypeMap.remove(oldRendering);
            }
        });
    }

    @Override
    public void updateRendering(OWLEntity ent) {
        boolean updateRendering = false;
        for (OWLOntology ont : this.owlModelManager.getActiveOntologies()) {
            if (!ont.containsEntityInSignature(ent)) continue;
            updateRendering = true;
            break;
        }
        this.removeRendering(ent);
        if (updateRendering) {
            this.addRendering(ent);
        }
    }

    @Override
    public Set<String> getOWLClassRenderings() {
        return this.owlClassMap.keySet();
    }

    @Override
    public Set<String> getOWLObjectPropertyRenderings() {
        return this.owlObjectPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLDataPropertyRenderings() {
        return this.owlDataPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLAnnotationPropertyRenderings() {
        return this.owlAnnotationPropertyMap.keySet();
    }

    @Override
    public Set<String> getOWLIndividualRenderings() {
        return this.owlIndividualMap.keySet();
    }

    @Override
    public Set<String> getOWLDatatypeRenderings() {
        return this.owlDatatypeMap.keySet();
    }

    @Override
    public Set<String> getOWLEntityRenderings() {
        HashSet<String> renderings = new HashSet<String>(this.owlClassMap.size() + this.owlObjectPropertyMap.size() + this.owlDataPropertyMap.size() + this.owlAnnotationPropertyMap.size() + this.owlIndividualMap.size() + this.owlDatatypeMap.size());
        renderings.addAll(this.owlClassMap.keySet());
        renderings.addAll(this.owlObjectPropertyMap.keySet());
        renderings.addAll(this.owlDataPropertyMap.keySet());
        renderings.addAll(this.owlAnnotationPropertyMap.keySet());
        renderings.addAll(this.owlIndividualMap.keySet());
        renderings.addAll(this.owlDatatypeMap.keySet());
        return renderings;
    }
}

