/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ProtegeManager;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.plugin.PluginUtilities;
import org.protege.editor.core.ui.RefreshableComponent;
import org.protege.editor.core.ui.error.ErrorLog;
import org.protege.editor.core.ui.error.ErrorNotificationLabel;
import org.protege.editor.core.ui.error.SendErrorReportHandler;
import org.protege.editor.core.ui.progress.BackgroundTaskLabel;
import org.protege.editor.core.ui.workspace.CustomWorkspaceTabsManager;
import org.protege.editor.core.ui.workspace.TabbedWorkspace;
import org.protege.editor.core.ui.workspace.Workspace;
import org.protege.editor.core.ui.workspace.WorkspaceFrame;
import org.protege.editor.core.ui.workspace.WorkspaceManager;
import org.protege.editor.core.ui.workspace.WorkspaceTab;
import org.protege.editor.core.ui.workspace.WorkspaceTabPlugin;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OWLCustomWorkspaceTabsManager;
import org.protege.editor.owl.model.OWLEntityDisplayProvider;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.UIReasonerExceptionHandler;
import org.protege.editor.owl.model.entity.OWLEntityCreationSet;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.OWLReasonerManagerImpl;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerInfo;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerPlugin;
import org.protege.editor.owl.model.inference.ProtegeOWLReasonerPluginJPFImpl;
import org.protege.editor.owl.model.inference.ReasonerDiedException;
import org.protege.editor.owl.model.inference.ReasonerInfoComparator;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.inference.ReasonerStatus;
import org.protege.editor.owl.model.inference.ReasonerUtilities;
import org.protege.editor.owl.model.selection.OWLSelectionHistoryManager;
import org.protege.editor.owl.model.selection.OWLSelectionHistoryManagerImpl;
import org.protege.editor.owl.model.selection.OWLSelectionModel;
import org.protege.editor.owl.model.selection.OWLSelectionModelImpl;
import org.protege.editor.owl.ui.OWLEntityCreationPanel;
import org.protege.editor.owl.ui.OWLWorkspaceViewsTab;
import org.protege.editor.owl.ui.find.EntityFinderField;
import org.protege.editor.owl.ui.inference.ConfigureReasonerAction;
import org.protege.editor.owl.ui.inference.ExplainInconsistentOntologyAction;
import org.protege.editor.owl.ui.inference.PrecomputeAction;
import org.protege.editor.owl.ui.inference.ReasonerProgressUI;
import org.protege.editor.owl.ui.navigation.OWLEntityNavPanel;
import org.protege.editor.owl.ui.ontology.OntologySourcesChangedHandlerUI;
import org.protege.editor.owl.ui.preferences.AnnotationPreferences;
import org.protege.editor.owl.ui.renderer.KeywordColourMap;
import org.protege.editor.owl.ui.renderer.OWLCellRenderer;
import org.protege.editor.owl.ui.renderer.OWLIconProvider;
import org.protege.editor.owl.ui.renderer.OWLIconProviderImpl;
import org.protege.editor.owl.ui.renderer.OWLOntologyCellRenderer;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.util.OWLComponentFactory;
import org.protege.editor.owl.ui.util.OWLComponentFactoryImpl;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.ImportChange;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAxiomChange;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.BufferingMode;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLEntityCollectingOntologyChangeListener;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;

public class OWLWorkspace
extends TabbedWorkspace
implements SendErrorReportHandler {
    private static final long serialVersionUID = 2340234247624617932L;
    private Logger logger = Logger.getLogger(OWLWorkspace.class);
    private static final String WINDOW_MODIFIED = "Window.documentModified";
    private static final int FINDER_BORDER = 1;
    private static final int FINDER_MIN_WIDTH = 250;
    private JComboBox ontologiesList;
    private ArrayList<OWLEntityDisplayProvider> entityDisplayProviders;
    private OWLIconProvider iconProvider;
    private Map<String, Color> keyWordColorMap;
    private OWLSelectionModel owlSelectionModel;
    private OWLSelectionHistoryManager owlSelectionHistoryManager;
    private List<URI> defaultAnnotationProperties;
    private OWLModelManagerListener owlModelManagerListener;
    private Set<EventType> reselectionEventTypes = new HashSet<EventType>();
    private ErrorNotificationLabel errorNotificationLabel;
    private BackgroundTaskLabel backgroundTaskLabel;
    private OWLEntityCollectingOntologyChangeListener listener;
    private Set<URI> hiddenAnnotationURIs;
    private OWLComponentFactory owlComponentFactory;
    private JPanel statusArea;
    private JLabel customizedProtege = new JLabel();
    private String altTitle;
    private boolean reasonerManagerStarted = false;
    private PrecomputeAction startReasonerAction = new PrecomputeAction();
    private PrecomputeAction synchronizeReasonerAction = new PrecomputeAction();
    private ExplainInconsistentOntologyAction explainInconsistentOntologyAction = new ExplainInconsistentOntologyAction();
    private JLabel reasonerStatus = new JLabel();
    private JCheckBox displayReasonerResults = new JCheckBox("Show Inferences");
    public static final String REASONER_INITIALIZE = "Start reasoner";
    public static final String REASONER_RESYNC = "Synchronize reasoner";
    public static final String REASONER_EXPLAIN = "Explain inconsistent ontology";

    public OWLEditorKit getOWLEditorKit() {
        return (OWLEditorKit)this.getEditorKit();
    }

    public OWLModelManager getOWLModelManager() {
        return this.getOWLEditorKit().getModelManager();
    }

    public void initialise() {
        this.entityDisplayProviders = new ArrayList();
        this.iconProvider = new OWLIconProviderImpl(this.getOWLEditorKit().getModelManager());
        this.owlSelectionModel = new OWLSelectionModelImpl();
        this.keyWordColorMap = new KeywordColourMap();
        this.defaultAnnotationProperties = new ArrayList<URI>();
        this.defaultAnnotationProperties.add(OWLRDFVocabulary.RDFS_COMMENT.getURI());
        super.initialise();
        this.errorNotificationLabel = new ErrorNotificationLabel(ProtegeApplication.getErrorLog(), (SendErrorReportHandler)this);
        this.backgroundTaskLabel = new BackgroundTaskLabel(ProtegeApplication.getBackgroundTaskManager());
        this.createActiveOntologyPanel();
        this.reselectionEventTypes.add(EventType.ACTIVE_ONTOLOGY_CHANGED);
        this.reselectionEventTypes.add(EventType.ONTOLOGY_RELOADED);
        this.reselectionEventTypes.add(EventType.ENTITY_RENDERER_CHANGED);
        this.reselectionEventTypes.add(EventType.ONTOLOGY_VISIBILITY_CHANGED);
        this.reselectionEventTypes.add(EventType.REASONER_CHANGED);
        this.hiddenAnnotationURIs = new HashSet<URI>();
        this.hiddenAnnotationURIs.addAll(AnnotationPreferences.getHiddenAnnotationURIs());
        this.owlComponentFactory = new OWLComponentFactoryImpl(this.getOWLEditorKit());
        final OWLModelManager mngr = this.getOWLModelManager();
        this.owlModelManagerListener = new OWLModelManagerListener(){

            @Override
            public void handleChange(OWLModelManagerChangeEvent event) {
                try {
                    OWLWorkspace.this.handleModelManagerEvent(event.getType());
                }
                catch (Exception t) {
                    ProtegeApplication.getErrorLog().logError((Throwable)t);
                }
            }
        };
        mngr.addListener(this.owlModelManagerListener);
        this.listener = new OWLEntityCollectingOntologyChangeListener(){

            public void ontologiesChanged() {
                OWLWorkspace.this.verifySelection(this.getEntities());
            }

            public void ontologiesChanged(List<? extends OWLOntologyChange> changes) throws OWLException {
                super.ontologiesChanged(changes);
                OWLWorkspace.this.handleOntologiesChanged(changes);
            }
        };
        mngr.addOntologyChangeListener((OWLOntologyChangeListener)this.listener);
        mngr.getOWLReasonerManager().setReasonerProgressMonitor(new ReasonerProgressUI(this.getOWLEditorKit()));
        mngr.getOWLReasonerManager().setReasonerExceptionHandler(new UIReasonerExceptionHandler(this));
        this.reasonerManagerStarted = true;
        this.updateReasonerStatus(false);
        this.displayReasonerResults.setSelected(mngr.getOWLReasonerManager().getReasonerPreferences().isShowInferences());
        this.displayReasonerResults.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReasonerPreferences prefs = mngr.getOWLReasonerManager().getReasonerPreferences();
                prefs.setShowInferences(OWLWorkspace.this.displayReasonerResults.isSelected());
            }
        });
        new OntologySourcesChangedHandlerUI(this);
    }

    private void handleOntologiesChanged(List<? extends OWLOntologyChange> changes) {
        boolean reasonerDirty = false;
        boolean ontologyIdsDirty = false;
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange instanceof SetOntologyID) {
                ontologyIdsDirty = true;
                continue;
            }
            if (oWLOntologyChange instanceof ImportChange) {
                reasonerDirty = true;
                continue;
            }
            if (!(oWLOntologyChange instanceof OWLAxiomChange)) continue;
            reasonerDirty = true;
        }
        if (reasonerDirty) {
            this.updateReasonerStatus(true);
        }
        if (ontologyIdsDirty) {
            this.updateTitleBar();
        }
        this.updateDirtyFlag();
    }

    private void updateDirtyFlag() {
        WorkspaceManager workspaceManager = ProtegeManager.getInstance().getEditorKitManager().getWorkspaceManager();
        WorkspaceFrame frame = workspaceManager.getFrame((Workspace)this);
        Set<OWLOntology> dirtyOntologies = this.getOWLModelManager().getDirtyOntologies();
        boolean dirty = false;
        for (OWLOntology ont : this.getOWLModelManager().getOntologies()) {
            if (!dirtyOntologies.contains(ont)) continue;
            dirty = true;
            break;
        }
        frame.getRootPane().putClientProperty(WINDOW_MODIFIED, dirty);
    }

    private void handleModelManagerEvent(EventType type) {
        if (this.reselectionEventTypes.contains((Object)type)) {
            this.logger.debug((Object)"Reselection event..... verifying selections.");
            this.verifySelection();
        }
        switch (type) {
            case ACTIVE_ONTOLOGY_CHANGED: {
                this.updateTitleBar();
                this.updateReasonerStatus(false);
                this.rebuildOntologyDropDown();
                this.ontologiesList.repaint();
                break;
            }
            case ONTOLOGY_CLASSIFIED: {
                this.updateReasonerStatus(false);
                this.verifySelection();
                this.updateReasonerStatus(false);
                break;
            }
            case ABOUT_TO_CLASSIFY: 
            case REASONER_CHANGED: {
                this.updateReasonerStatus(false);
                break;
            }
            case ONTOLOGY_LOADED: 
            case ONTOLOGY_CREATED: {
                if (this.getTabCount() <= 0) break;
                this.setSelectedTab(0);
                break;
            }
            case ENTITY_RENDERER_CHANGED: 
            case ONTOLOGY_RELOADED: {
                this.rebuildOntologyDropDown();
                this.refreshComponents();
                break;
            }
            case ONTOLOGY_SAVED: {
                this.updateDirtyFlag();
                this.updateTitleBar();
                break;
            }
        }
    }

    public void refreshComponents() {
        this.refreshComponents((Component)((Object)this));
    }

    public void refreshComponents(Component component) {
        Font f;
        if (component instanceof Container) {
            Container cont = (Container)component;
            for (Component childComp : cont.getComponents()) {
                this.refreshComponents(childComp);
            }
        }
        if (this.isComponentFontSizeSensitive(component) && (f = component.getFont()) != null) {
            component.setFont(f.deriveFont(f.getStyle(), OWLRendererPreferences.getInstance().getFontSize()));
        }
        if (component instanceof RefreshableComponent) {
            ((RefreshableComponent)component).refreshComponent();
        }
    }

    private boolean isComponentFontSizeSensitive(Component component) {
        return component instanceof JTextComponent || component instanceof JLabel || component instanceof JTree || component instanceof JList || component instanceof JTable;
    }

    protected void verifySelection(Set<? extends OWLEntity> entities) {
        HashSet<? extends OWLEntity> unreferencedEntities = new HashSet<OWLEntity>(entities);
        block0: for (OWLEntity oWLEntity : entities) {
            if (oWLEntity == null) continue;
            for (OWLOntology ont : this.getOWLModelManager().getActiveOntologies()) {
                if (!ont.containsEntityInSignature(oWLEntity)) continue;
                unreferencedEntities.remove(oWLEntity);
                continue block0;
            }
        }
        for (OWLEntity oWLEntity : unreferencedEntities) {
            this.getOWLSelectionModel().clearLastSelectedEntity(oWLEntity);
        }
    }

    protected void verifySelection() {
        OWLSelectionModel selectionModel = this.getOWLSelectionModel();
        OWLClass lastSelectedClass = selectionModel.getLastSelectedClass();
        OWLObjectProperty lastSelectedObjectProperty = selectionModel.getLastSelectedObjectProperty();
        OWLDataProperty lastSelectedDataProperty = selectionModel.getLastSelectedDataProperty();
        OWLAnnotationProperty lastSelectedAnnotationProperty = selectionModel.getLastSelectedAnnotationProperty();
        OWLNamedIndividual lastSelectedIndividual = selectionModel.getLastSelectedIndividual();
        OWLDatatype lastSelectedDatatype = selectionModel.getLastSelectedDatatype();
        OWLEntity selectedEntity = selectionModel.getSelectedEntity();
        selectionModel.setSelectedEntity((OWLEntity)lastSelectedClass);
        selectionModel.setSelectedEntity((OWLEntity)lastSelectedObjectProperty);
        selectionModel.setSelectedEntity((OWLEntity)lastSelectedDataProperty);
        selectionModel.setSelectedEntity((OWLEntity)lastSelectedAnnotationProperty);
        selectionModel.setSelectedEntity((OWLEntity)lastSelectedIndividual);
        selectionModel.setSelectedEntity((OWLEntity)lastSelectedDatatype);
        selectionModel.setSelectedEntity(selectedEntity);
        this.verifySelection(CollectionFactory.createSet((Object[])new OWLEntity[]{lastSelectedClass, lastSelectedDataProperty, lastSelectedObjectProperty, lastSelectedAnnotationProperty, lastSelectedIndividual, lastSelectedDatatype, selectedEntity}));
    }

    public boolean isHiddenAnnotationURI(URI annotationURI) {
        return this.hiddenAnnotationURIs.contains(annotationURI);
    }

    public Set<URI> getHiddenAnnotationURIs() {
        return Collections.unmodifiableSet(this.hiddenAnnotationURIs);
    }

    public void setCustomizedBy(String customizedText) {
        this.customizedProtege.setText(customizedText);
        this.statusArea.repaint();
    }

    public void setHiddenAnnotationURI(URI annotationURI, boolean hidden) {
        boolean changed = hidden ? this.hiddenAnnotationURIs.add(annotationURI) : this.hiddenAnnotationURIs.remove(annotationURI);
        if (changed) {
            AnnotationPreferences.setHiddenAnnotationURIs(this.hiddenAnnotationURIs);
            this.getOWLEditorKit().getModelManager().fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
        }
    }

    public void setHiddenAnnotationURIs(Set<URI> hiddenURIs) {
        if (!((Object)hiddenURIs).equals(this.hiddenAnnotationURIs)) {
            this.hiddenAnnotationURIs.clear();
            this.hiddenAnnotationURIs.addAll(hiddenURIs);
            AnnotationPreferences.setHiddenAnnotationURIs(this.hiddenAnnotationURIs);
            this.getOWLEditorKit().getModelManager().fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
        }
    }

    protected void initialiseExtraMenuItems(JMenuBar menuBar) {
        super.initialiseExtraMenuItems(menuBar);
        this.getOntologiesMenu(menuBar);
        this.rebuildReasonerMenu(menuBar);
        this.addReasonerListener(menuBar);
        this.updateTitleBar();
        JMenu windowMenu = OWLWorkspace.getWindowMenu(menuBar);
        windowMenu.addSeparator();
        windowMenu.add(new AbstractAction("Refresh User Interface"){
            private static final long serialVersionUID = 9136219526373256639L;

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLWorkspace.this.refreshComponents();
            }
        });
    }

    private void rebuildReasonerMenu(JMenuBar menuBar) {
        final OWLModelManager mngr = this.getOWLModelManager();
        JMenu reasonerMenu = OWLWorkspace.getReasonerMenu(menuBar);
        reasonerMenu.removeAll();
        this.startReasonerAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.startReasonerAction.putValue("Name", REASONER_INITIALIZE);
        reasonerMenu.add((Action)((Object)this.startReasonerAction));
        this.synchronizeReasonerAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.synchronizeReasonerAction.putValue("Name", REASONER_RESYNC);
        reasonerMenu.add((Action)((Object)this.synchronizeReasonerAction));
        this.explainInconsistentOntologyAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        this.explainInconsistentOntologyAction.putValue("Name", REASONER_EXPLAIN);
        this.explainInconsistentOntologyAction.setEnabled(false);
        reasonerMenu.add((Action)((Object)this.explainInconsistentOntologyAction));
        ConfigureReasonerAction configureAction = new ConfigureReasonerAction();
        configureAction.setEditorKit((EditorKit)this.getOWLEditorKit());
        configureAction.putValue("Name", "Configure...");
        reasonerMenu.add((Action)((Object)configureAction));
        reasonerMenu.addSeparator();
        ButtonGroup bg = new ButtonGroup();
        Set<ProtegeOWLReasonerInfo> factories = mngr.getOWLReasonerManager().getInstalledReasonerFactories();
        ArrayList<ProtegeOWLReasonerInfo> factoriesList = new ArrayList<ProtegeOWLReasonerInfo>(factories);
        Collections.sort(factoriesList, new ReasonerInfoComparator());
        for (final ProtegeOWLReasonerInfo plugin : factoriesList) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(plugin.getReasonerName());
            item.setSelected(mngr.getOWLReasonerManager().getCurrentReasonerFactoryId().equals(plugin.getReasonerId()));
            reasonerMenu.add(item);
            bg.add(item);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    mngr.getOWLReasonerManager().setCurrentReasonerFactoryId(plugin.getReasonerId());
                }
            });
        }
    }

    private void addReasonerListener(final JMenuBar menuBar) {
        IExtensionRegistry registry = PluginUtilities.getInstance().getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("org.protege.editor.owl", "inference_reasonerfactory");
        registry.addListener(new IRegistryEventListener(){

            public void added(IExtension[] extensions) {
                OWLReasonerManagerImpl reasonerManager = (OWLReasonerManagerImpl)OWLWorkspace.this.getOWLModelManager().getOWLReasonerManager();
                HashSet<ProtegeOWLReasonerPlugin> plugins = new HashSet<ProtegeOWLReasonerPlugin>();
                for (IExtension extension : extensions) {
                    plugins.add(new ProtegeOWLReasonerPluginJPFImpl(OWLWorkspace.this.getOWLModelManager(), extension));
                }
                reasonerManager.addReasonerFactories(plugins);
                OWLWorkspace.this.rebuildReasonerMenu(menuBar);
                menuBar.repaint();
            }

            public void added(IExtensionPoint[] extensionPoints) {
            }

            public void removed(IExtension[] extensions) {
            }

            public void removed(IExtensionPoint[] extensionPoints) {
            }
        }, point.getUniqueIdentifier());
    }

    private JMenu getOntologiesMenu(JMenuBar menuBar) {
        return OWLWorkspace.getMenu(menuBar, "Ontologies");
    }

    private static JMenu getReasonerMenu(JMenuBar menuBar) {
        return OWLWorkspace.getMenu(menuBar, "Reasoner");
    }

    private static JMenu getWindowMenu(JMenuBar menuBar) {
        return OWLWorkspace.getMenu(menuBar, "Window");
    }

    private static JMenu getMenu(JMenuBar menuBar, String name) {
        for (int i = 0; i < menuBar.getMenuCount(); ++i) {
            if (menuBar.getMenu(i).getText() == null || !menuBar.getMenu(i).getText().equals(name)) continue;
            return menuBar.getMenu(i);
        }
        return null;
    }

    private void createActiveOntologyPanel() {
        JPanel topBarPanel = new JPanel(new GridBagLayout());
        topBarPanel.setBorder(BorderFactory.createEmptyBorder(5, 10, 3, 10));
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.insets = new Insets(0, 4, 0, 4);
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        topBarPanel.add((Component)new OWLEntityNavPanel(this.getOWLEditorKit()), gbc);
        final OWLModelManager mngr = this.getOWLModelManager();
        this.ontologiesList = new JComboBox();
        this.ontologiesList.setToolTipText("Active ontology");
        this.ontologiesList.setRenderer(new OWLOntologyCellRenderer(this.getOWLEditorKit()));
        this.rebuildOntologyDropDown();
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 100.0;
        gbc.weighty = 0.0;
        gbc.fill = 2;
        gbc.anchor = 10;
        topBarPanel.add((Component)this.ontologiesList, gbc);
        this.ontologiesList.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OWLOntology ont = (OWLOntology)OWLWorkspace.this.ontologiesList.getSelectedItem();
                if (ont != null) {
                    mngr.setActiveOntology(ont);
                }
            }
        });
        JPanel finderHolder = new JPanel();
        finderHolder.setLayout(new BoxLayout(finderHolder, 2));
        final EntityFinderField entityFinderField = new EntityFinderField((JComponent)((Object)this), this.getOWLEditorKit());
        int height = entityFinderField.getPreferredSize().height;
        finderHolder.setMinimumSize(new Dimension(250, height + 4));
        finderHolder.add((Component)((Object)entityFinderField));
        gbc.gridx = 2;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        topBarPanel.add((Component)finderHolder, gbc);
        gbc.gridx = 3;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 0;
        gbc.anchor = 10;
        topBarPanel.add((Component)this.backgroundTaskLabel);
        topBarPanel.add((Component)this.errorNotificationLabel);
        this.add(topBarPanel, "North");
        KeyStroke findKeyStroke = KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.getInputMap(2).put(findKeyStroke, "FOCUS_FIND");
        this.getActionMap().put("FOCUS_FIND", new AbstractAction(){
            private static final long serialVersionUID = -2205711779338124168L;

            @Override
            public void actionPerformed(ActionEvent e) {
                entityFinderField.requestFocus();
            }
        });
        this.updateTitleBar();
    }

    public void setTitle(String title) {
        this.altTitle = title;
        this.updateTitleBar();
    }

    protected String getTitle() {
        if (this.altTitle != null) {
            return this.altTitle;
        }
        OWLModelManager mngr = this.getOWLModelManager();
        OWLOntology activeOntology = mngr.getActiveOntology();
        if (activeOntology == null) {
            return null;
        }
        URI locURI = mngr.getOntologyPhysicalURI(activeOntology);
        String location = "*";
        if (locURI != null && !locURI.toString().isEmpty()) {
            location = locURI.toString();
            if ("file".equals(locURI.getScheme())) {
                location = new File(locURI).getPath();
            }
        }
        String ontShortName = mngr.getRendering((OWLObject)activeOntology);
        IRI defaultDocumentIRI = activeOntology.getOntologyID().getDefaultDocumentIRI();
        String documentIRIPart = "";
        if (defaultDocumentIRI != null) {
            documentIRIPart = " (" + defaultDocumentIRI + ") ";
        }
        return ontShortName + documentIRIPart + " : [" + location + "]";
    }

    private void updateTitleBar() {
        WorkspaceFrame f = ProtegeManager.getInstance().getFrame((Workspace)this);
        if (f != null) {
            f.setTitle(this.getTitle());
        }
        this.ontologiesList.repaint();
    }

    private void updateReasonerStatus(boolean changesInProgress) {
        ReasonerStatus newStatus;
        if (!this.reasonerManagerStarted) {
            return;
        }
        OWLReasonerManager reasonerManager = this.getOWLEditorKit().getOWLModelManager().getOWLReasonerManager();
        try {
            newStatus = reasonerManager.getReasonerStatus();
        }
        catch (ReasonerDiedException reasonerDied) {
            newStatus = ReasonerStatus.REASONER_NOT_INITIALIZED;
            ReasonerUtilities.warnThatReasonerDied(null, reasonerDied);
        }
        if (changesInProgress && (newStatus == ReasonerStatus.INITIALIZED || newStatus == ReasonerStatus.INCONSISTENT) && reasonerManager.getCurrentReasoner().getBufferingMode() == BufferingMode.BUFFERING) {
            newStatus = ReasonerStatus.OUT_OF_SYNC;
        }
        this.updateReasonerStatus(newStatus);
    }

    private void updateReasonerStatus(ReasonerStatus status) {
        this.reasonerStatus.setText(status.getDescription());
        this.startReasonerAction.setEnabled(status.isEnableInitialization());
        this.startReasonerAction.putValue("ShortDescription", status.getInitializationTooltip());
        this.synchronizeReasonerAction.setEnabled(status.isEnableSynchronization());
        this.synchronizeReasonerAction.putValue("ShortDescription", status.getSynchronizationTooltip());
        this.explainInconsistentOntologyAction.setEnabled(status == ReasonerStatus.INCONSISTENT);
        KeyStroke shortcut = KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
        this.startReasonerAction.putValue("AcceleratorKey", status.isEnableInitialization() ? shortcut : null);
        this.synchronizeReasonerAction.putValue("AcceleratorKey", status.isEnableSynchronization() ? shortcut : null);
    }

    public void displayOWLEntity(OWLEntity owlEntity) {
        JComponent component;
        OWLEntityDisplayProvider candidate = null;
        for (OWLEntityDisplayProvider provider : this.entityDisplayProviders) {
            if (!provider.canDisplay(owlEntity)) continue;
            if (candidate == null) {
                candidate = provider;
            }
            if (!provider.getDisplayComponent().isShowing()) continue;
            candidate = provider;
            break;
        }
        if (candidate != null && (component = candidate.getDisplayComponent()) != null) {
            OWLWorkspace.bringComponentToFront(component);
        }
    }

    public CustomWorkspaceTabsManager getCustomTabsManager() {
        return new OWLCustomWorkspaceTabsManager();
    }

    private static void bringComponentToFront(Component component) {
        if (component.isShowing()) {
            return;
        }
        Container parent = component.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof JTabbedPane) {
            ((JTabbedPane)parent).setSelectedComponent(component);
        }
        OWLWorkspace.bringComponentToFront(parent);
    }

    public void registerOWLEntityDisplayProvider(OWLEntityDisplayProvider provider) {
        this.entityDisplayProviders.add(provider);
    }

    public void unregisterOWLEntityDisplayProvider(OWLEntityDisplayProvider provider) {
        this.entityDisplayProviders.remove(provider);
    }

    public void dispose() {
        super.dispose();
        this.owlComponentFactory.dispose();
        this.getOWLModelManager().removeListener(this.owlModelManagerListener);
        this.getOWLModelManager().removeOntologyChangeListener((OWLOntologyChangeListener)this.listener);
    }

    private void rebuildOntologyDropDown() {
        try {
            TreeSet<OWLObject> ts = new TreeSet<OWLObject>(this.getOWLModelManager().getOWLObjectComparator());
            ts.addAll(this.getOWLModelManager().getOntologies());
            this.ontologiesList.setModel(new DefaultComboBoxModel<Object>(ts.toArray()));
            this.ontologiesList.setSelectedItem(this.getOWLModelManager().getActiveOntology());
        }
        catch (Exception e) {
            ProtegeApplication.getErrorLog().logError((Throwable)e);
        }
    }

    public OWLIconProvider getOWLIconProvider() {
        return this.iconProvider;
    }

    public void setOWLIconProvider(OWLIconProvider provider) {
        this.iconProvider = provider;
    }

    public OWLCellRenderer createOWLCellRenderer() {
        return this.createOWLCellRenderer(true, true);
    }

    public OWLCellRenderer createOWLCellRenderer(boolean renderExpression, boolean renderIcon) {
        return new OWLCellRenderer(this.getOWLEditorKit(), renderExpression, renderIcon);
    }

    public Map<String, Color> getKeyWordColorMap() {
        return this.keyWordColorMap;
    }

    public OWLSelectionModel getOWLSelectionModel() {
        return this.owlSelectionModel;
    }

    public OWLSelectionHistoryManager getOWLSelectionHistoryManager() {
        if (this.owlSelectionHistoryManager == null) {
            this.owlSelectionHistoryManager = new OWLSelectionHistoryManagerImpl(this.getOWLSelectionModel());
        }
        return this.owlSelectionHistoryManager;
    }

    public OWLEntityCreationSet<OWLClass> createOWLClass() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), "Please enter a class name", OWLClass.class);
    }

    public OWLEntityCreationSet<OWLObjectProperty> createOWLObjectProperty() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), "Please enter an object property name", OWLObjectProperty.class);
    }

    public OWLEntityCreationSet<OWLDataProperty> createOWLDataProperty() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), "Please enter a data property name", OWLDataProperty.class);
    }

    public OWLEntityCreationSet<OWLAnnotationProperty> createOWLAnnotationProperty() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), "Please enter an annotation property name", OWLAnnotationProperty.class);
    }

    public OWLEntityCreationSet<OWLNamedIndividual> createOWLIndividual() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), "Please enter an individual name", OWLNamedIndividual.class);
    }

    public OWLEntityCreationSet<OWLDatatype> createOWLDatatype() {
        return OWLEntityCreationPanel.showDialog(this.getOWLEditorKit(), "Please enter a datatype name", OWLDatatype.class);
    }

    public OWLComponentFactory getOWLComponentFactory() {
        return this.owlComponentFactory;
    }

    public static KeyStroke getCreateSubKeyStroke() {
        return KeyStroke.getKeyStroke(92, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public static KeyStroke getCreateSibKeyStroke() {
        return KeyStroke.getKeyStroke(47, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    }

    public boolean sendErrorReport(ErrorLog errorLog) {
        return true;
    }

    public JComponent getStatusArea() {
        if (this.statusArea == null) {
            this.statusArea = new JPanel();
            this.statusArea.setLayout(new BoxLayout(this.statusArea, 0));
            this.statusArea.add(Box.createHorizontalGlue());
            this.statusArea.add(this.customizedProtege);
            this.statusArea.add(Box.createHorizontalGlue());
            this.statusArea.add(this.reasonerStatus);
            this.statusArea.add(Box.createHorizontalStrut(15));
            this.statusArea.add(this.displayReasonerResults);
            this.statusArea.add(Box.createHorizontalStrut(20));
        }
        return this.statusArea;
    }

    public WorkspaceTab createWorkspaceTab(final String name) {
        final OWLWorkspaceViewsTab tab = new OWLWorkspaceViewsTab();
        tab.setup(new WorkspaceTabPlugin(){

            public TabbedWorkspace getWorkspace() {
                return OWLWorkspace.this;
            }

            public String getLabel() {
                return name;
            }

            public Icon getIcon() {
                return null;
            }

            public String getIndex() {
                return "Z";
            }

            public URL getDefaultViewConfigFile() {
                try {
                    return new File(this.getId() + "-config.xml").toURI().toURL();
                }
                catch (MalformedURLException uriex) {
                    ProtegeApplication.getErrorLog().logError((Throwable)uriex);
                    return null;
                }
            }

            public String getId() {
                return "WorkspaceTab" + System.nanoTime();
            }

            public String getDocumentation() {
                return null;
            }

            public WorkspaceTab newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                return tab;
            }
        });
        return tab;
    }
}

