/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.model;

import java.io.File;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.coode.xml.XMLWriterPreferences;
import org.protege.editor.core.AbstractModelManager;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.model.MissingImportHandler;
import org.protege.editor.owl.model.MissingImportHandlerImpl;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.SaveErrorHandler;
import org.protege.editor.owl.model.XMLWriterPrefs;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCache;
import org.protege.editor.owl.model.cache.OWLEntityRenderingCacheImpl;
import org.protege.editor.owl.model.cache.OWLObjectRenderingCache;
import org.protege.editor.owl.model.classexpression.anonymouscls.AnonymousDefinedClassManager;
import org.protege.editor.owl.model.entity.CustomOWLEntityFactory;
import org.protege.editor.owl.model.entity.OWLEntityFactory;
import org.protege.editor.owl.model.event.EventType;
import org.protege.editor.owl.model.event.OWLModelManagerChangeEvent;
import org.protege.editor.owl.model.event.OWLModelManagerListener;
import org.protege.editor.owl.model.find.OWLEntityFinder;
import org.protege.editor.owl.model.find.OWLEntityFinderImpl;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManager;
import org.protege.editor.owl.model.hierarchy.OWLHierarchyManagerImpl;
import org.protege.editor.owl.model.history.HistoryManager;
import org.protege.editor.owl.model.history.HistoryManagerImpl;
import org.protege.editor.owl.model.inference.OWLReasonerManager;
import org.protege.editor.owl.model.inference.OWLReasonerManagerImpl;
import org.protege.editor.owl.model.inference.ReasonerPreferences;
import org.protege.editor.owl.model.io.AutoMappedRepositoryIRIMapper;
import org.protege.editor.owl.model.io.IOListener;
import org.protege.editor.owl.model.io.IOListenerEvent;
import org.protege.editor.owl.model.io.OntologySourcesManager;
import org.protege.editor.owl.model.io.UserResolvedIRIMapper;
import org.protege.editor.owl.model.io.WebConnectionIRIMapper;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.model.selection.ontologies.ImportsClosureOntologySelectionStrategy;
import org.protege.editor.owl.model.selection.ontologies.OntologySelectionStrategy;
import org.protege.editor.owl.model.util.ListenerManager;
import org.protege.editor.owl.ui.OWLObjectRenderingComparator;
import org.protege.editor.owl.ui.clsdescriptioneditor.ManchesterOWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.clsdescriptioneditor.OWLExpressionCheckerFactory;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandler;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLEntityRendererListener;
import org.protege.editor.owl.ui.renderer.OWLModelManagerEntityRenderer;
import org.protege.editor.owl.ui.renderer.OWLObjectRenderer;
import org.protege.editor.owl.ui.renderer.OWLObjectRendererImpl;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.plugin.RendererPlugin;
import org.protege.owlapi.apibinding.ProtegeOWLManager;
import org.protege.owlapi.model.ProtegeOWLOntologyManager;
import org.protege.xmlcatalog.XMLCatalog;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeException;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyIRIMapper;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.util.SimpleIRIMapper;

public class OWLModelManagerImpl
extends AbstractModelManager
implements OWLModelManager,
OWLEntityRendererListener,
OWLOntologyChangeListener,
OWLOntologyLoaderListener {
    private static final Logger logger = Logger.getLogger(OWLModelManagerImpl.class);
    private HistoryManager historyManager;
    private OWLModelManagerEntityRenderer entityRenderer;
    private OWLObjectRenderer objectRenderer;
    private OWLOntology activeOntology;
    private OWLEntityRenderingCache owlEntityRenderingCache;
    private OWLObjectRenderingCache owlObjectRenderingCache;
    private OWLEntityFinder entityFinder;
    private OWLReasonerManager owlReasonerManager;
    private Set<OWLOntologyID> dirtyOntologies;
    private ProtegeOWLOntologyManager manager;
    private OntologyCatalogManager ontologyLibraryManager;
    private ExplanationManager explanationManager;
    private OWLEntityFactory entityFactory;
    private Set<OWLOntology> activeOntologies;
    private Set<OntologySelectionStrategy> ontSelectionStrategies;
    private OntologySelectionStrategy activeOntologiesStrategy;
    private OWLExpressionCheckerFactory owlExpressionCheckerFactory;
    private SaveErrorHandler saveErrorHandler;
    private OntologyLoadErrorHandler loadErrorHandler;
    private AutoMappedRepositoryIRIMapper autoMappedRepositoryIRIMapper;
    private UserResolvedIRIMapper userResolvedIRIMapper;
    private List<OWLModelManagerListener> modelManagerChangeListeners;
    private ListenerManager<OWLModelManagerListener> modelManagerListenerManager = new ListenerManager();
    private ListenerManager<OWLOntologyChangeListener> changeListenerManager = new ListenerManager();
    private List<IOListener> ioListeners;

    public OWLModelManagerImpl() {
        this.manager = ProtegeOWLManager.createOWLOntologyManager();
        this.manager.setUseWriteSafety(true);
        this.manager.setUseSwingThread(true);
        this.manager.setSilentMissingImportsHandling(true);
        this.manager.addOntologyChangeListener((OWLOntologyChangeListener)this);
        this.manager.addOntologyLoaderListener((OWLOntologyLoaderListener)this);
        this.autoMappedRepositoryIRIMapper = new AutoMappedRepositoryIRIMapper(this);
        this.userResolvedIRIMapper = new UserResolvedIRIMapper(new MissingImportHandlerImpl());
        this.manager.clearIRIMappers();
        this.manager.addIRIMapper((OWLOntologyIRIMapper)this.userResolvedIRIMapper);
        this.manager.addIRIMapper((OWLOntologyIRIMapper)new WebConnectionIRIMapper());
        this.manager.addIRIMapper((OWLOntologyIRIMapper)this.autoMappedRepositoryIRIMapper);
        this.dirtyOntologies = new HashSet<OWLOntologyID>();
        this.ontSelectionStrategies = new HashSet<OntologySelectionStrategy>();
        this.modelManagerChangeListeners = new ArrayList<OWLModelManagerListener>();
        this.ioListeners = new ArrayList<IOListener>();
        this.objectRenderer = new OWLObjectRendererImpl(this);
        this.owlEntityRenderingCache = new OWLEntityRenderingCacheImpl();
        this.owlEntityRenderingCache.setOWLModelManager(this);
        this.owlObjectRenderingCache = new OWLObjectRenderingCache(this);
        this.owlExpressionCheckerFactory = new ManchesterOWLExpressionCheckerFactory(this);
        this.activeOntologies = new HashSet<OWLOntology>();
        this.activeOntologiesStrategy = new ImportsClosureOntologySelectionStrategy(this);
        this.getOWLEntityRenderer();
        XMLWriterPreferences.getInstance().setUseNamespaceEntities(XMLWriterPrefs.getInstance().isUseEntities());
        this.put(OntologySourcesManager.ID, new OntologySourcesManager(this));
    }

    public void dispose() {
        super.dispose();
        OntologySourcesManager sourcesMngr = (OntologySourcesManager)this.get(OntologySourcesManager.ID);
        this.removeIOListener(sourcesMngr);
        try {
            this.owlEntityRenderingCache.dispose();
            this.owlObjectRenderingCache.dispose();
            if (this.entityRenderer != null) {
                this.entityRenderer.dispose();
            }
            this.owlReasonerManager.dispose();
        }
        catch (Exception e) {
            logger.error((Object)(e.getMessage() + "\n"), (Throwable)e);
        }
        this.modelManagerListenerManager.dumpWarningForAllListeners(logger, Level.ERROR, "(Listeners should be removed in the plugin dispose method!)");
        this.changeListenerManager.dumpWarningForAllListeners(logger, Level.ERROR, "(Listeners should be removed in the plugin dispose method!)");
    }

    public boolean isDirty() {
        return !this.dirtyOntologies.isEmpty();
    }

    @Override
    public boolean isDirty(OWLOntology ontology) {
        return this.dirtyOntologies.contains(ontology.getOntologyID());
    }

    @Override
    public void setClean(OWLOntology ontology) {
        this.dirtyOntologies.remove(ontology.getOntologyID());
    }

    public ProtegeOWLOntologyManager getOWLOntologyManager() {
        return this.manager;
    }

    @Override
    public OntologyCatalogManager getOntologyCatalogManager() {
        if (this.ontologyLibraryManager == null) {
            this.ontologyLibraryManager = new OntologyCatalogManager();
        }
        return this.ontologyLibraryManager;
    }

    @Override
    public OWLHierarchyManager getOWLHierarchyManager() {
        OWLHierarchyManager hm = (OWLHierarchyManager)this.get(OWLHierarchyManager.ID);
        if (hm == null) {
            hm = new OWLHierarchyManagerImpl(this);
            this.put(OWLHierarchyManager.ID, hm);
        }
        return hm;
    }

    @Override
    public ExplanationManager getExplanationManager() {
        return this.explanationManager;
    }

    @Override
    public void setExplanationManager(ExplanationManager explanationManager) {
        this.explanationManager = explanationManager;
    }

    public boolean loadOntologyFromPhysicalURI(URI uri) {
        if (UIUtil.isLocalFile((URI)uri)) {
            this.addRootFolder(new File(uri).getParentFile());
        }
        OWLOntology ontology = null;
        try {
            ontology = this.manager.loadOntologyFromOntologyDocument(IRI.create((URI)uri));
            this.setActiveOntology(ontology);
            this.fireEvent(EventType.ONTOLOGY_LOADED);
            OWLOntologyID id = ontology.getOntologyID();
            if (!id.isAnonymous()) {
                this.manager.addIRIMapper((OWLOntologyIRIMapper)new SimpleIRIMapper(id.getDefaultDocumentIRI(), IRI.create((URI)uri)));
            }
        }
        catch (OWLOntologyCreationException oWLOntologyCreationException) {
            // empty catch block
        }
        return ontology != null;
    }

    public void startedLoadingOntology(OWLOntologyLoaderListener.LoadingStartedEvent event) {
        logger.info((Object)("loading " + event.getOntologyID() + " from " + event.getDocumentIRI()));
        this.fireBeforeLoadEvent(event.getOntologyID(), event.getDocumentIRI().toURI());
    }

    public void finishedLoadingOntology(OWLOntologyLoaderListener.LoadingFinishedEvent event) {
        if (!event.isSuccessful()) {
            OWLOntologyCreationException e = event.getException();
            if (this.loadErrorHandler != null) {
                try {
                    this.loadErrorHandler.handleErrorLoadingOntology(event.getOntologyID(), event.getDocumentIRI().toURI(), e);
                }
                catch (Throwable e1) {
                    ErrorLogPanel.showErrorDialog((Throwable)e1);
                }
            }
        }
        this.fireAfterLoadEvent(event.getOntologyID(), event.getDocumentIRI().toURI());
    }

    @Override
    public XMLCatalog addRootFolder(File dir) {
        return this.ontologyLibraryManager.addFolder(dir);
    }

    private void fireBeforeLoadEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.beforeLoad(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    private void fireAfterLoadEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.afterLoad(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    @Override
    public URI getOntologyPhysicalURI(OWLOntology ontology) {
        IRI ontologyDocumentIRI = this.manager.getOntologyDocumentIRI(ontology);
        if (ontologyDocumentIRI != null) {
            if (this.isDefaultOWLAPIDocumentIRI(ontologyDocumentIRI)) {
                return URI.create("");
            }
            return ontologyDocumentIRI.toURI();
        }
        return URI.create("");
    }

    private boolean isDefaultOWLAPIDocumentIRI(IRI iri) {
        URI uri = iri.toURI();
        String scheme = uri.getScheme();
        return scheme != null && scheme.equals("owlapi");
    }

    @Override
    public void setPhysicalURI(OWLOntology ontology, URI physicalURI) {
        this.manager.setOntologyDocumentIRI(ontology, IRI.create((URI)physicalURI));
    }

    @Override
    public OWLOntology createNewOntology(OWLOntologyID ontologyID, URI physicalURI) throws OWLOntologyCreationException {
        if (physicalURI != null) {
            this.manager.addIRIMapper((OWLOntologyIRIMapper)new SimpleIRIMapper(ontologyID.getDefaultDocumentIRI(), IRI.create((URI)physicalURI)));
        }
        OWLOntology ont = this.manager.createOntology(ontologyID);
        this.setActiveOntology(ont);
        if (physicalURI != null) {
            try {
                File containingDirectory = new File(physicalURI).getParentFile();
                if (containingDirectory.exists()) {
                    this.getOntologyCatalogManager().addFolder(containingDirectory);
                }
            }
            catch (IllegalArgumentException iae) {
                logger.info((Object)("Cannot generate ontology catalog for ontology at " + physicalURI));
            }
        }
        this.fireEvent(EventType.ONTOLOGY_CREATED);
        return ont;
    }

    @Override
    public OWLOntology reload(OWLOntology ont) throws OWLOntologyCreationException {
        IRI ontologyDocumentIRI = IRI.create((URI)this.getOntologyPhysicalURI(ont));
        this.manager.removeOntology(ont);
        boolean wasTheActiveOntology = false;
        if (ont.equals(this.activeOntology)) {
            wasTheActiveOntology = true;
            this.activeOntology = null;
        }
        this.dirtyOntologies.remove(ont.getOntologyID());
        try {
            ont = this.manager.loadOntologyFromOntologyDocument(ontologyDocumentIRI);
        }
        catch (Throwable t) {
            this.manager.ontologyCreated(ont);
            this.manager.setOntologyDocumentIRI(ont, ontologyDocumentIRI);
            throw t instanceof OWLOntologyCreationException ? (OWLOntologyCreationException)t : new OWLOntologyCreationException(t);
        }
        if (wasTheActiveOntology) {
            this.activeOntology = ont;
        }
        this.rebuildActiveOntologiesCache();
        this.refreshRenderer();
        this.fireEvent(EventType.ONTOLOGY_RELOADED);
        return ont;
    }

    @Override
    public boolean removeOntology(OWLOntology ont) {
        if (this.manager.contains(ont.getOntologyID()) && this.manager.getOntologies().size() > 1) {
            boolean resetActiveOntologyRequired = ont.equals(this.activeOntology);
            this.activeOntologies.remove(ont);
            this.dirtyOntologies.remove(ont.getOntologyID());
            this.manager.removeOntology(ont);
            if (resetActiveOntologyRequired) {
                OWLOntology newActiveOnt = null;
                if (!this.activeOntologies.isEmpty()) {
                    newActiveOnt = this.activeOntologies.iterator().next();
                }
                if (newActiveOnt == null && !this.manager.getOntologies().isEmpty()) {
                    newActiveOnt = (OWLOntology)this.manager.getOntologies().iterator().next();
                }
                this.setActiveOntology(newActiveOnt, true);
            } else {
                this.setActiveOntology(this.activeOntology, true);
            }
            return true;
        }
        return false;
    }

    @Override
    public void save() throws OWLOntologyStorageException {
        for (OWLOntologyID ontId : new HashSet<OWLOntologyID>(this.dirtyOntologies)) {
            if (this.manager.contains(ontId)) {
                this.save(this.manager.getOntology(ontId));
                continue;
            }
            this.dirtyOntologies.remove(ontId);
        }
    }

    @Override
    public void save(OWLOntology ont) throws OWLOntologyStorageException {
        URI physicalURI = this.manager.getOntologyDocumentIRI(ont).toURI();
        try {
            this.fireBeforeSaveEvent(ont.getOntologyID(), physicalURI);
            try {
                if (!UIUtil.isLocalFile((URI)physicalURI)) {
                    throw new ProtocolException("Cannot save file to remote location: " + physicalURI);
                }
                OWLOntologyFormat format = this.manager.getOntologyFormat(ont);
                this.manager.saveOntology(ont, format, IRI.create((URI)physicalURI));
                this.manager.setOntologyDocumentIRI(ont, IRI.create((URI)physicalURI));
            }
            catch (IOException e) {
                throw new OWLOntologyStorageException("Error while saving ontology " + ont.getOntologyID() + " to " + physicalURI, (Throwable)e);
            }
            logger.info((Object)("Saved " + this.getRendering((OWLObject)ont) + " to " + physicalURI));
            this.dirtyOntologies.remove(ont.getOntologyID());
            this.fireEvent(EventType.ONTOLOGY_SAVED);
            this.fireAfterSaveEvent(ont.getOntologyID(), physicalURI);
        }
        catch (OWLOntologyStorageException e) {
            if (this.saveErrorHandler != null) {
                try {
                    this.saveErrorHandler.handleErrorSavingOntology(ont, physicalURI, e);
                }
                catch (Exception e1) {
                    throw new OWLOntologyStorageException((Throwable)e1);
                }
            }
            throw e;
        }
    }

    @Override
    @Deprecated
    public void saveAs() throws OWLOntologyStorageException {
        this.save();
    }

    private void fireBeforeSaveEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.beforeSave(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    private void fireAfterSaveEvent(OWLOntologyID ontologyID, URI physicalURI) {
        for (IOListener listener : new ArrayList<IOListener>(this.ioListeners)) {
            try {
                listener.afterSave(new IOListenerEvent(ontologyID, physicalURI));
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    @Override
    public Set<OWLOntology> getOntologies() {
        return this.manager.getOntologies();
    }

    @Override
    public Set<OWLOntology> getDirtyOntologies() {
        HashSet<OWLOntology> ontologies = new HashSet<OWLOntology>();
        for (OWLOntologyID ontId : new ArrayList<OWLOntologyID>(this.dirtyOntologies)) {
            if (this.manager.contains(ontId)) {
                ontologies.add(this.manager.getOntology(ontId));
                continue;
            }
            this.dirtyOntologies.remove(ontId);
        }
        return ontologies;
    }

    @Override
    public void setDirty(OWLOntology ontology) {
        this.dirtyOntologies.add(ontology.getOntologyID());
    }

    @Override
    public OWLOntology getActiveOntology() {
        return this.activeOntology;
    }

    @Override
    public OWLDataFactory getOWLDataFactory() {
        return this.manager.getOWLDataFactory();
    }

    @Override
    public Set<OWLOntology> getActiveOntologies() {
        return this.activeOntologies;
    }

    @Override
    public boolean isActiveOntologyMutable() {
        return this.isMutable(this.getActiveOntology());
    }

    @Override
    public boolean isMutable(OWLOntology ontology) {
        return true;
    }

    @Override
    public void setActiveOntology(OWLOntology activeOntology) {
        this.setActiveOntology(activeOntology, false);
    }

    @Override
    public void setActiveOntologiesStrategy(OntologySelectionStrategy strategy) {
        this.activeOntologiesStrategy = strategy;
        this.setActiveOntology(this.getActiveOntology(), true);
        this.fireEvent(EventType.ONTOLOGY_VISIBILITY_CHANGED);
    }

    @Override
    public OntologySelectionStrategy getActiveOntologiesStrategy() {
        return this.activeOntologiesStrategy;
    }

    @Override
    public Set<OntologySelectionStrategy> getActiveOntologiesStrategies() {
        return this.ontSelectionStrategies;
    }

    private void setActiveOntology(OWLOntology activeOntology, boolean force) {
        if (!force && this.activeOntology != null && this.activeOntology.equals(activeOntology)) {
            return;
        }
        this.activeOntology = activeOntology;
        logger.info((Object)("Setting active ontology to " + activeOntology.getOntologyID()));
        this.rebuildActiveOntologiesCache();
        this.entityRenderer.ontologiesChanged();
        this.rebuildEntityIndices();
        this.fireEvent(EventType.ACTIVE_ONTOLOGY_CHANGED);
        logger.info((Object)"... active ontology changed");
    }

    @Override
    public void registerOntologySelectionStrategy(OntologySelectionStrategy strategy) {
        this.ontSelectionStrategies.add(strategy);
    }

    private void rebuildActiveOntologiesCache() {
        this.activeOntologies.clear();
        this.activeOntologies.addAll(this.activeOntologiesStrategy.getOntologies());
    }

    @Override
    public void applyChange(OWLOntologyChange change) {
        try {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null) {
                change = adcManager.getChangeRewriter().rewriteChange(change);
            }
            this.manager.applyChange(change);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    @Override
    public void applyChanges(List<? extends OWLOntologyChange> changes) {
        try {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null) {
                changes = adcManager.getChangeRewriter().rewriteChanges(changes);
            }
            this.manager.applyChanges(changes);
        }
        catch (OWLOntologyChangeException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        this.getHistoryManager().logChanges(changes);
        boolean refreshActiveOntology = false;
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (oWLOntologyChange instanceof SetOntologyID) {
                SetOntologyID ontologyIDChange = (SetOntologyID)oWLOntologyChange;
                this.dirtyOntologies.remove(ontologyIDChange.getOriginalOntologyID());
            }
            this.dirtyOntologies.add(oWLOntologyChange.getOntology().getOntologyID());
            if (!oWLOntologyChange.isImportChange()) continue;
            refreshActiveOntology = true;
        }
        if (refreshActiveOntology) {
            this.setActiveOntology(this.getActiveOntology(), true);
        }
    }

    @Override
    public boolean isChangedEntity(OWLEntity entity) {
        return false;
    }

    @Override
    public HistoryManager getHistoryManager() {
        if (this.historyManager == null) {
            this.historyManager = new HistoryManagerImpl(this);
        }
        return this.historyManager;
    }

    @Override
    public void addOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.manager.addOntologyChangeListener(listener);
        this.changeListenerManager.recordListenerAdded(listener);
    }

    @Override
    public void removeOntologyChangeListener(OWLOntologyChangeListener listener) {
        this.manager.removeOntologyChangeListener(listener);
        this.changeListenerManager.recordListenerRemoved(listener);
    }

    @Override
    public void addListener(OWLModelManagerListener listener) {
        this.modelManagerChangeListeners.add(listener);
        this.modelManagerListenerManager.recordListenerAdded(listener);
    }

    @Override
    public void removeListener(OWLModelManagerListener listener) {
        this.modelManagerChangeListeners.remove(listener);
        this.modelManagerListenerManager.recordListenerRemoved(listener);
    }

    @Override
    public void fireEvent(EventType type) {
        OWLModelManagerChangeEvent event = new OWLModelManagerChangeEvent(this, type);
        for (OWLModelManagerListener listener : new ArrayList<OWLModelManagerListener>(this.modelManagerChangeListeners)) {
            try {
                listener.handleChange(event);
            }
            catch (Throwable e) {
                logger.warn((Object)("Exception thrown by listener: " + listener.getClass().getName() + ".  Detatching bad listener!"));
                ProtegeApplication.getErrorLog().logError(e);
                this.modelManagerChangeListeners.remove(listener);
            }
        }
    }

    @Override
    public void addIOListener(IOListener listener) {
        this.ioListeners.add(listener);
    }

    @Override
    public void removeIOListener(IOListener listener) {
        this.ioListeners.remove(listener);
    }

    @Override
    public OWLModelManagerEntityRenderer getOWLEntityRenderer() {
        if (this.entityRenderer == null) {
            try {
                OWLRendererPreferences preferences = OWLRendererPreferences.getInstance();
                RendererPlugin plugin = preferences.getRendererPlugin();
                this.entityRenderer = plugin.newInstance();
                this.loadRenderer();
            }
            catch (ClassNotFoundException e) {
                logger.error((Object)e.getMessage());
            }
            catch (InstantiationException e) {
                logger.error((Object)e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.error((Object)e.getMessage());
            }
            if (this.entityRenderer == null) {
                this.entityRenderer = new OWLEntityRendererImpl();
                this.loadRenderer();
            }
        }
        return this.entityRenderer;
    }

    @Override
    public String getRendering(OWLObject object) {
        if (object instanceof OWLEntity) {
            AnonymousDefinedClassManager adcManager = (AnonymousDefinedClassManager)this.get(AnonymousDefinedClassManager.ID);
            if (adcManager != null && object instanceof OWLClass && adcManager.isAnonymous((OWLClass)object)) {
                return this.owlObjectRenderingCache.getRendering((OWLObject)adcManager.getExpression((OWLClass)object), this.getOWLObjectRenderer());
            }
            this.getOWLEntityRenderer();
            String rendering = this.owlEntityRenderingCache.getRendering((OWLEntity)object);
            if (rendering != null) {
                return rendering;
            }
            return this.getOWLEntityRenderer().render((OWLEntity)object);
        }
        return this.owlObjectRenderingCache.getRendering(object, this.getOWLObjectRenderer());
    }

    @Override
    public void renderingChanged(OWLEntity entity, OWLModelManagerEntityRenderer renderer) {
        this.owlEntityRenderingCache.updateRendering(entity);
        this.owlObjectRenderingCache.clear();
        for (OWLModelManagerListener listener : new ArrayList<OWLModelManagerListener>(this.modelManagerChangeListeners)) {
            listener.handleChange(new OWLModelManagerChangeEvent(this, EventType.ENTITY_RENDERING_CHANGED));
        }
    }

    @Override
    public void refreshRenderer() {
        if (this.entityRenderer != null) {
            this.entityRenderer.removeListener(this);
            try {
                this.entityRenderer.dispose();
            }
            catch (Exception e) {
                ProtegeApplication.getErrorLog().logError((Throwable)e);
            }
        }
        this.entityRenderer = null;
        this.getOWLEntityRenderer();
        this.loadRenderer();
    }

    private void loadRenderer() {
        this.entityRenderer.addListener(this);
        this.entityRenderer.setup(this);
        this.entityRenderer.initialise();
        this.rebuildEntityIndices();
        this.fireEvent(EventType.ENTITY_RENDERER_CHANGED);
    }

    @Override
    public void setOWLEntityRenderer(OWLModelManagerEntityRenderer renderer) {
        this.refreshRenderer();
    }

    @Override
    public OWLObjectRenderer getOWLObjectRenderer() {
        return this.objectRenderer;
    }

    @Override
    public OWLExpressionCheckerFactory getOWLExpressionCheckerFactory() {
        return this.owlExpressionCheckerFactory;
    }

    @Override
    public OWLEntityFactory getOWLEntityFactory() {
        if (this.entityFactory == null) {
            this.entityFactory = new CustomOWLEntityFactory(this);
        }
        return this.entityFactory;
    }

    @Override
    public void setOWLEntityFactory(OWLEntityFactory owlEntityFactory) {
        this.entityFactory = owlEntityFactory;
    }

    @Override
    public OWLEntityFinder getOWLEntityFinder() {
        if (this.entityFinder == null) {
            this.entityFinder = new OWLEntityFinderImpl(this, this.owlEntityRenderingCache);
        }
        return this.entityFinder;
    }

    @Override
    public Comparator<OWLObject> getOWLObjectComparator() {
        OWLObjectRenderingComparator comparator = (OWLObjectRenderingComparator)this.get("OWL_OBJECT_COMPARATOR_KEY");
        if (comparator == null) {
            comparator = new OWLObjectRenderingComparator(this);
            this.put("OWL_OBJECT_COMPARATOR_KEY", comparator);
        }
        return comparator;
    }

    private void rebuildEntityIndices() {
        logger.info((Object)"Rebuilding entity indices...");
        long t0 = System.currentTimeMillis();
        this.owlEntityRenderingCache.rebuild();
        this.owlObjectRenderingCache.clear();
        logger.info((Object)("... rebuilt in " + (System.currentTimeMillis() - t0) + " ms"));
    }

    @Override
    public OWLReasonerManager getOWLReasonerManager() {
        if (this.owlReasonerManager == null) {
            this.owlReasonerManager = new OWLReasonerManagerImpl(this);
        }
        return this.owlReasonerManager;
    }

    @Override
    public OWLReasoner getReasoner() {
        return this.getOWLReasonerManager().getCurrentReasoner();
    }

    @Override
    public ReasonerPreferences getReasonerPreferences() {
        return this.getOWLReasonerManager().getReasonerPreferences();
    }

    @Override
    public void setMissingImportHandler(MissingImportHandler missingImportHandler) {
        this.userResolvedIRIMapper.setMissingImportHandler(missingImportHandler);
    }

    @Override
    public void setSaveErrorHandler(SaveErrorHandler handler) {
        this.saveErrorHandler = handler;
    }

    @Override
    public void setLoadErrorHandler(OntologyLoadErrorHandler handler) {
        this.loadErrorHandler = handler;
    }
}

