/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl;

import java.io.File;
import java.net.ProtocolException;
import java.net.URI;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.packageadmin.PackageAdmin;
import org.protege.editor.core.BookMarkedURIManager;
import org.protege.editor.core.Disposable;
import org.protege.editor.core.ProtegeApplication;
import org.protege.editor.core.editorkit.AbstractEditorKit;
import org.protege.editor.core.editorkit.EditorKit;
import org.protege.editor.core.editorkit.EditorKitDescriptor;
import org.protege.editor.core.editorkit.EditorKitFactory;
import org.protege.editor.core.editorkit.RecentEditorKitManager;
import org.protege.editor.core.ui.error.ErrorLogPanel;
import org.protege.editor.owl.OWLEditorKitFactory;
import org.protege.editor.owl.ProtegeOWL;
import org.protege.editor.owl.model.OWLModelManager;
import org.protege.editor.owl.model.OWLModelManagerImpl;
import org.protege.editor.owl.model.OWLWorkspace;
import org.protege.editor.owl.model.SaveErrorHandler;
import org.protege.editor.owl.model.io.IOListenerPlugin;
import org.protege.editor.owl.model.io.IOListenerPluginInstance;
import org.protege.editor.owl.model.io.IOListenerPluginLoader;
import org.protege.editor.owl.ui.OntologyFormatPanel;
import org.protege.editor.owl.ui.UIHelper;
import org.protege.editor.owl.ui.error.OntologyLoadErrorHandlerUI;
import org.protege.editor.owl.ui.explanation.ExplanationManager;
import org.protege.editor.owl.ui.ontology.OntologyPreferences;
import org.protege.editor.owl.ui.ontology.imports.missing.MissingImportHandlerUI;
import org.semanticweb.owlapi.io.RDFXMLOntologyFormat;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLException;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.model.OWLOntologyFormat;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLOntologyStorerNotFoundException;
import org.semanticweb.owlapi.util.VersionInfo;
import org.semanticweb.owlapi.vocab.PrefixOWLOntologyFormat;

public class OWLEditorKit
extends AbstractEditorKit<OWLEditorKitFactory> {
    private static final Logger logger = Logger.getLogger(OWLEditorKit.class);
    public static final String ID = "OWLEditorKit";
    public static final String URI_KEY = "URI";
    public static final String FILE_URI_SCHEME = "file";
    private OWLWorkspace workspace;
    private OWLModelManager modelManager;
    private Set<URI> newPhysicalURIs;
    private OntologyLoadErrorHandlerUI loadErrorHandler;
    private ServiceRegistration registration;
    private boolean modifiedDocument = false;
    private OWLOntologyChangeListener ontologyChangeListener;

    public OWLEditorKit(OWLEditorKitFactory editorKitFactory) {
        super((EditorKitFactory)editorKitFactory);
    }

    protected void initialise() {
        logger.info((Object)("Using OWL API version " + VersionInfo.getVersionInfo().getVersion()));
        this.newPhysicalURIs = new HashSet<URI>();
        this.modelManager = new OWLModelManagerImpl();
        this.modelManager.setExplanationManager(new ExplanationManager(this));
        this.modelManager.setMissingImportHandler(new MissingImportHandlerUI(this));
        this.modelManager.setSaveErrorHandler(new SaveErrorHandler(){

            @Override
            public void handleErrorSavingOntology(OWLOntology ont, URI physicalURIForOntology, OWLOntologyStorageException e) throws Exception {
                OWLEditorKit.this.handleSaveError(ont, physicalURIForOntology, e);
            }
        });
        this.ontologyChangeListener = new OWLOntologyChangeListener(){

            public void ontologiesChanged(List<? extends OWLOntologyChange> owlOntologyChanges) throws OWLException {
                OWLEditorKit.this.modifiedDocument = true;
            }
        };
        this.modelManager.addOntologyChangeListener(this.ontologyChangeListener);
        this.loadErrorHandler = new OntologyLoadErrorHandlerUI(this);
        this.modelManager.setLoadErrorHandler(this.loadErrorHandler);
        this.loadIOListenerPlugins();
        this.registration = ProtegeOWL.getBundleContext().registerService(EditorKit.class.getCanonicalName(), (Object)this, new Hashtable());
        this.getWorkspace().refreshComponents();
    }

    public boolean hasModifiedDocument() {
        return this.modifiedDocument;
    }

    @Deprecated
    public void setOWLModelManager(OWLModelManager modelManager) {
        this.modelManager = modelManager;
        ServiceReference sr = ProtegeOWL.getBundleContext().getServiceReference(PackageAdmin.class.getCanonicalName());
        PackageAdmin admin = (PackageAdmin)ProtegeOWL.getBundleContext().getService(sr);
        Bundle customizer = admin.getBundle(modelManager.getClass());
        String name = (String)customizer.getHeaders().get("Bundle-Name");
        if (name == null) {
            name = customizer.getSymbolicName();
        }
        this.getOWLWorkspace().setCustomizedBy("Prot\u00e9g\u00e9 Customized by " + name);
    }

    public String getId() {
        return ID;
    }

    public OWLWorkspace getWorkspace() {
        if (this.workspace == null) {
            this.workspace = new OWLWorkspace();
            this.workspace.setup((EditorKit)this);
            this.workspace.initialise();
        }
        return this.workspace;
    }

    public OWLWorkspace getOWLWorkspace() {
        return this.getWorkspace();
    }

    public OWLModelManager getModelManager() {
        return this.modelManager;
    }

    public OWLModelManager getOWLModelManager() {
        return this.getModelManager();
    }

    public boolean handleLoadRecentRequest(EditorKitDescriptor descriptor) throws Exception {
        URI uri = descriptor.getURI(URI_KEY);
        return uri != null && this.handleLoadFrom(uri);
    }

    public boolean handleLoadRequest() throws Exception {
        File f = new UIHelper(this).chooseOWLFile("Select an OWL file");
        return f != null && this.handleLoadFrom(f.toURI());
    }

    public boolean handleLoadFrom(URI uri) throws Exception {
        this.loadErrorHandler.setReloadFlag(false);
        boolean success = ((OWLModelManagerImpl)this.getModelManager()).loadOntologyFromPhysicalURI(uri);
        if (success) {
            this.addRecent(uri);
        } else if (this.loadErrorHandler.getReloadFlag()) {
            success = this.handleLoadFrom(uri);
        }
        this.modifiedDocument = true;
        return success;
    }

    private OWLOntologyID createDefaultOntologyId() {
        return new OWLOntologyID(this.createFreshOntologyIRI());
    }

    private IRI createFreshOntologyIRI() {
        OntologyPreferences ontologyPreferences = OntologyPreferences.getInstance();
        return IRI.create((URI)ontologyPreferences.generateNextURI());
    }

    public boolean handleNewRequest() throws Exception {
        OWLOntologyID id = this.createDefaultOntologyId();
        OWLOntology ont = this.getModelManager().createNewOntology(id, id.getDefaultDocumentIRI().toURI());
        OWLOntologyManager owlOntologyManager = this.getModelManager().getOWLOntologyManager();
        owlOntologyManager.setOntologyFormat(ont, (OWLOntologyFormat)new RDFXMLOntologyFormat());
        return true;
    }

    public void handleSave() throws Exception {
        Set<OWLOntology> dirtyOntologies = this.getModelManager().getDirtyOntologies();
        this.getWorkspace().save();
        if (dirtyOntologies.isEmpty()) {
            return;
        }
        try {
            this.getModelManager().save();
            for (URI uri : this.newPhysicalURIs) {
                this.addRecent(uri);
            }
            this.newPhysicalURIs.clear();
        }
        catch (OWLOntologyStorerNotFoundException e) {
            OWLOntology ont = this.getModelManager().getActiveOntology();
            OWLOntologyFormat format = this.getModelManager().getOWLOntologyManager().getOntologyFormat(ont);
            String message = "Could not save ontology in the specified format (" + format + ").\n" + "Please select 'Save As' and choose another format.";
            logger.warn((Object)message);
            ErrorLogPanel.showErrorDialog((Throwable)new OWLOntologyStorageException(message, (Throwable)e));
        }
    }

    public void handleSaveAs() throws Exception {
        OWLOntology ont = this.getModelManager().getActiveOntology();
        if (this.handleSaveAs(ont)) {
            // empty if block
        }
    }

    private boolean handleSaveAs(OWLOntology ont) throws Exception {
        File file;
        OWLOntologyManager man = this.getModelManager().getOWLOntologyManager();
        OWLOntologyFormat oldFormat = man.getOntologyFormat(ont);
        OWLOntologyFormat format = OntologyFormatPanel.showDialog(this, oldFormat, "Choose a format to use when saving the " + this.getModelManager().getRendering((OWLObject)ont) + " ontology");
        if (format == null) {
            logger.warn((Object)"Please select a valid format");
            return false;
        }
        if (oldFormat instanceof PrefixOWLOntologyFormat && format instanceof PrefixOWLOntologyFormat) {
            PrefixOWLOntologyFormat oldPrefixes = (PrefixOWLOntologyFormat)oldFormat;
            for (String name : oldPrefixes.getPrefixNames()) {
                ((PrefixOWLOntologyFormat)format).setPrefix(name, oldPrefixes.getPrefix(name));
            }
        }
        if ((file = this.getSaveAsOWLFile(ont)) != null) {
            man.setOntologyFormat(ont, format);
            man.setOntologyDocumentIRI(ont, IRI.create((File)file));
            this.getModelManager().save(ont);
            this.addRecent(file.toURI());
            return true;
        }
        return false;
    }

    private File getSaveAsOWLFile(OWLOntology ont) {
        UIHelper helper = new UIHelper(this);
        File file = helper.saveOWLFile("Please select a location in which to save: " + this.getModelManager().getRendering((OWLObject)ont));
        if (file != null) {
            int extensionIndex = file.toString().lastIndexOf(46);
            if (extensionIndex == -1) {
                file = new File(file.toString() + ".owl");
            } else if (extensionIndex != file.toString().length() - 4) {
                file = new File(file.toString() + ".owl");
            }
        }
        return file;
    }

    public void addRecent(URI physicalURI) {
        String label = physicalURI.toString();
        if (FILE_URI_SCHEME.equals(physicalURI.getScheme())) {
            label = new File(physicalURI).getPath();
        } else {
            BookMarkedURIManager.getInstance().add(physicalURI);
        }
        EditorKitDescriptor descriptor = new EditorKitDescriptor(label, this.getEditorKitFactory());
        descriptor.setURI(URI_KEY, physicalURI);
        RecentEditorKitManager.getInstance().add(descriptor);
    }

    private void handleSaveError(OWLOntology ont, URI physicalURIForOntology, OWLOntologyStorageException e) throws Exception {
        if (e.getCause() == null || !(e.getCause() instanceof ProtocolException)) {
            throw e;
        }
        this.handleSaveAs(ont);
    }

    private void loadIOListenerPlugins() {
        IOListenerPluginLoader loader = new IOListenerPluginLoader(this);
        for (IOListenerPlugin pl : loader.getPlugins()) {
            try {
                IOListenerPluginInstance instance = (IOListenerPluginInstance)pl.newInstance();
                this.getModelManager().addIOListener(instance);
            }
            catch (Throwable e) {
                ProtegeApplication.getErrorLog().logError(e);
            }
        }
    }

    public Disposable get(Object key) {
        return this.getOWLModelManager().get(key);
    }

    public void put(Object key, Disposable value) {
        this.getOWLModelManager().put(key, value);
    }

    public void dispose() {
        this.getModelManager().removeOntologyChangeListener(this.ontologyChangeListener);
        super.dispose();
        this.workspace.dispose();
        try {
            this.modelManager.dispose();
        }
        catch (Exception e) {
            ErrorLogPanel.showErrorDialog((Throwable)e);
        }
        if (this.registration != null) {
            this.registration.unregister();
            this.registration = null;
        }
    }
}

